/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.notification.driver;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import me.insidezhou.southernquiet.notification.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractListenerManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractListenerManager.class);
    private boolean inited = false;

    @EventListener(value={ContextRefreshedEvent.class})
    public void initListener(ContextRefreshedEvent event) {
        this.initListener(event.getApplicationContext());
    }

    public void initListener(ApplicationContext applicationContext) {
        if (this.inited) {
            return;
        }
        Arrays.stream(applicationContext.getBeanDefinitionNames()).map(name -> {
            try {
                return applicationContext.getBean(name);
            }
            catch (BeansException e) {
                log.info("\u67e5\u627eNotificationListener\u65f6\uff0cbean\u672a\u80fd\u521d\u59cb\u5316: {}", name);
                return null;
            }
        }).filter(bean -> null != bean).forEach(bean -> Arrays.stream(ReflectionUtils.getAllDeclaredMethods(bean.getClass())).forEach(method -> AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)method, NotificationListener.class).forEach(listener -> {
            if (log.isDebugEnabled()) {
                log.debug("\u627e\u5230NotificationListener\uff1a{}(id={}) {}#{}", new Object[]{listener.notification().getSimpleName(), listener.name(), bean.getClass().getSimpleName(), method.getName()});
            }
            this.initListener((NotificationListener)listener, bean, (Method)method);
        })));
        this.inited = true;
    }

    protected abstract void initListener(NotificationListener var1, Object var2, Method var3);
}

