/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.filesystem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import org.springframework.util.StringUtils;

public class NormalizedPath
implements Serializable {
    private static final long serialVersionUID = -8700923055584230554L;
    public static final NormalizedPath root = new NormalizedPath("");
    private String[] parentNames = new String[0];
    private String name = "";

    public NormalizedPath(String path) {
        if (!StringUtils.hasText((String)path)) {
            return;
        }
        if ("".equalsIgnoreCase(path)) {
            return;
        }
        String p = path.replace("\\", FileSystem.PATH_SEPARATOR_STRING);
        String[] pathElements = (String[])Stream.of(p.split(FileSystem.PATH_SEPARATOR_STRING)).filter(item -> StringUtils.hasText((String)item)).toArray(String[]::new);
        if (0 == pathElements.length) {
            return;
        }
        if (1 == pathElements.length) {
            this.setName(pathElements[0]);
            return;
        }
        int lastIndex = pathElements.length - 1;
        this.setParentNames(Arrays.copyOf(pathElements, lastIndex));
        this.setName(pathElements[lastIndex]);
    }

    public NormalizedPath(String[] pathElements) {
        if (0 == pathElements.length) {
            return;
        }
        int lastIndex = pathElements.length - 1;
        this.setParentNames(Arrays.copyOf(pathElements, lastIndex));
        this.setName(pathElements[lastIndex]);
    }

    public String[] getParentNames() {
        return this.parentNames;
    }

    public void setParentNames(String[] parentNames) {
        this.parentNames = parentNames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParent() {
        switch (this.parentNames.length) {
            case 0: {
                return StringUtils.isEmpty((Object)this.name) ? "" : FileSystem.PATH_SEPARATOR_STRING;
            }
            case 1: {
                return FileSystem.PATH_SEPARATOR_STRING + this.parentNames[0];
            }
        }
        return FileSystem.PATH_SEPARATOR_STRING + String.join((CharSequence)FileSystem.PATH_SEPARATOR_STRING, this.parentNames);
    }

    public NormalizedPath getParentPath() {
        return new NormalizedPath(this.getParentNames());
    }

    public String toString() {
        String parent = this.getParent();
        return parent.equals(FileSystem.PATH_SEPARATOR_STRING) ? FileSystem.PATH_SEPARATOR_STRING + this.name : parent + FileSystem.PATH_SEPARATOR_STRING + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NormalizedPath)) {
            return false;
        }
        NormalizedPath that = (NormalizedPath)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

