/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import me.insidezhou.southernquiet.filesystem.NormalizedPath;
import org.springframework.util.Assert;

public class PathMeta
implements Serializable {
    private static final long serialVersionUID = 3373353696843442643L;
    private String parent;
    private String name;
    private boolean isDirectory = true;
    private Instant creationTime;
    private Instant lastModifiedTime;
    private Instant lastAccessTime;
    private long size;

    public PathMeta(NormalizedPath normalizedPath, InputStream stream) {
        Assert.notNull((Object)normalizedPath, (String)"normalizedPath");
        this.parent = normalizedPath.getParent();
        this.name = normalizedPath.getName();
        if (null == stream) {
            this.setDirectory(true);
            this.setSize(-1L);
        } else {
            this.setDirectory(false);
            try {
                this.setSize(stream.available());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public PathMeta(String path, InputStream stream) {
        this(new NormalizedPath(path), stream);
    }

    public PathMeta(NormalizedPath normalizedPath) {
        this(normalizedPath, null);
    }

    public PathMeta(String path) {
        this(new NormalizedPath(path), null);
    }

    public String getPath() {
        return this.getParent() + FileSystem.PATH_SEPARATOR_STRING + this.name;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parent", this.getParent());
        map.put("name", this.getName());
        map.put("isDirectory", this.isDirectory());
        map.put("creationTime", this.getCreationTime());
        map.put("lastModifiedTime", this.getLastModifiedTime());
        map.put("lastAccessTime", this.getLastAccessTime());
        map.put("size", this.getSize());
        return map;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean directory) {
        this.isDirectory = directory;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public Instant getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Instant lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Instant lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

