/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.filesystem.driver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.FrameworkAutoConfiguration;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import me.insidezhou.southernquiet.filesystem.FileSystemException;
import me.insidezhou.southernquiet.filesystem.InvalidFileException;
import me.insidezhou.southernquiet.filesystem.NormalizedPath;
import me.insidezhou.southernquiet.filesystem.PathMeta;
import me.insidezhou.southernquiet.filesystem.PathMetaSort;
import me.insidezhou.southernquiet.filesystem.PathNotFoundException;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class LocalFileSystem
implements FileSystem {
    private String workingRoot;

    public LocalFileSystem(FrameworkAutoConfiguration.LocalFileSystemProperties properties) {
        String workingRoot = SystemPropertyUtils.resolvePlaceholders((String)properties.getWorkingRoot());
        Path workingPath = Paths.get(workingRoot, new String[0]);
        try {
            this.createDirectories(workingPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.workingRoot = workingRoot;
    }

    @Override
    public void createDirectory(String path) {
        try {
            Files.createDirectories(this.getWorkingPath(path), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void put(String path, InputStream stream) throws InvalidFileException {
        Path workingPath = this.getWorkingPath(path);
        try {
            this.createDirectories(workingPath.getParent());
            Files.write(workingPath, StreamUtils.copyToByteArray((InputStream)stream), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InvalidFileException(path, e);
        }
    }

    @Override
    public void put(String path, CharSequence txt) throws InvalidFileException {
        Path workingPath = this.getWorkingPath(path);
        try {
            this.createDirectories(workingPath.getParent());
            Files.write(workingPath, txt.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InvalidFileException(path, e);
        }
    }

    @Override
    public boolean exists(String path) {
        Path workingPath = this.getWorkingPath(path);
        return Files.exists(workingPath, new LinkOption[0]);
    }

    @Override
    public InputStream openReadStream(String path) throws InvalidFileException {
        Path workingPath = this.getWorkingPath(path);
        try {
            return Files.newInputStream(workingPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InvalidFileException(path, e);
        }
    }

    @Override
    public OutputStream openWriteStream(String path) throws InvalidFileException {
        Path workingPath = this.getWorkingPath(path);
        try {
            this.createDirectories(workingPath.getParent());
            return Files.newOutputStream(workingPath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new InvalidFileException(path, e);
        }
    }

    @Override
    public void move(String source, String destination, boolean replaceExisting) throws FileSystemException {
        this.moveOrCopy(true, source, destination, replaceExisting);
    }

    @Override
    public void copy(String source, String destination, boolean replaceExisting) throws FileSystemException {
        this.moveOrCopy(false, source, destination, replaceExisting);
    }

    @Override
    public void delete(String path) {
        Path workingPath = this.getWorkingPath(path);
        if (Files.notExists(workingPath, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(workingPath, new LinkOption[0])) {
            try {
                Files.deleteIfExists(workingPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        try {
            Files.walkFileTree(workingPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void touchCreation(String path) {
        Path workingPath = this.getWorkingPath(path);
        BasicFileAttributeView attributes = Files.getFileAttributeView(workingPath, BasicFileAttributeView.class, new LinkOption[0]);
        try {
            attributes.setTimes(null, null, FileTime.from(Instant.now()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void touchLastModified(String path) {
        Path workingPath = this.getWorkingPath(path);
        try {
            Files.setLastModifiedTime(workingPath, FileTime.from(Instant.now()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void touchLastAccess(String path) {
        Path workingPath = this.getWorkingPath(path);
        BasicFileAttributeView attributes = Files.getFileAttributeView(workingPath, BasicFileAttributeView.class, new LinkOption[0]);
        try {
            attributes.setTimes(null, FileTime.from(Instant.now()), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PathMeta meta(String path) {
        NormalizedPath normalizedPath = new NormalizedPath(path);
        return this.meta(normalizedPath, this.getWorkingPath(normalizedPath));
    }

    @Override
    public Stream<? extends PathMeta> directories(String path, String search, boolean recursive, int offset, int limit, PathMetaSort sort) throws PathNotFoundException {
        Stream<PathMeta> stream = this.pathStream(path, search, recursive, sort).filter(PathMeta::isDirectory);
        if (offset > 0) {
            stream = stream.skip(offset);
        }
        if (limit > 0) {
            stream = stream.limit(limit);
        }
        return stream;
    }

    @Override
    public Stream<? extends PathMeta> files(String path, String search, boolean recursive, int offset, int limit, PathMetaSort sort) throws PathNotFoundException {
        Stream<PathMeta> stream = this.pathStream(path, search, recursive, sort).filter(m -> !m.isDirectory());
        if (offset > 0) {
            stream = stream.skip(offset);
        }
        if (limit > 0) {
            stream = stream.limit(limit);
        }
        return stream;
    }

    private Path getWorkingPath(NormalizedPath path) {
        return Paths.get(this.workingRoot + path.toString(), new String[0]);
    }

    private Path getWorkingPath(String path) {
        return Paths.get(this.workingRoot + new NormalizedPath(path).toString(), new String[0]);
    }

    private NormalizedPath getNormalizedPath(Path path) {
        return new NormalizedPath(path.subpath(Paths.get(this.workingRoot, new String[0]).getNameCount(), path.getNameCount()).toString());
    }

    private void moveOrCopy(boolean move, String source, String destination, boolean replaceExisting) throws FileSystemException {
        Stream<Path> stream;
        Path src = this.getWorkingPath(source);
        Path dest = this.getWorkingPath(destination);
        if (Files.notExists(src, new LinkOption[0])) {
            throw new PathNotFoundException(source);
        }
        if (Files.notExists(dest, new LinkOption[0])) {
            try {
                this.moveOrCopy(move, src, dest, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new FileSystemException(source + " " + destination, e);
            }
            return;
        }
        if (Files.isDirectory(src, new LinkOption[0])) {
            if (!Files.isDirectory(dest, new LinkOption[0])) {
                throw new FileSystemException("\u4e0d\u80fd\u628a\u76ee\u5f55\u79fb\u52a8\u6216\u590d\u5236\u5230\u6587\u4ef6\u3002");
            }
            try {
                stream = Files.walk(src, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0]));
            }
            catch (IOException e) {
                throw new FileSystemException(source + " " + destination, e);
            }
        } else {
            stream = Stream.of(src);
        }
        if (replaceExisting) {
            stream.forEach(path -> {
                Path target = dest.resolve(path.relativize(src));
                try {
                    this.moveOrCopy(move, src, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            stream.forEach(path -> {
                Path target = dest.resolve(path.relativize(src));
                if (Files.exists(target, new LinkOption[0])) {
                    return;
                }
                try {
                    this.moveOrCopy(move, src, target, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void moveOrCopy(boolean move, Path src, Path dest, CopyOption ... options) throws IOException {
        HashSet<CopyOption> opts = new HashSet<CopyOption>(Arrays.asList(options));
        opts.add(StandardCopyOption.COPY_ATTRIBUTES);
        if (move) {
            Files.move(src, dest, opts.toArray(new CopyOption[opts.size()]));
        } else {
            Files.copy(src, dest, opts.toArray(new CopyOption[opts.size()]));
        }
    }

    private Stream<PathMeta> pathStream(String path, String search, boolean recursive, PathMetaSort sort) throws PathNotFoundException {
        Path workingPath = this.getWorkingPath(path);
        if (Files.notExists(workingPath, new LinkOption[0])) {
            throw new PathNotFoundException(path);
        }
        try {
            Stream<Path> stream = recursive ? Files.walk(workingPath, new FileVisitOption[0]) : Files.list(workingPath);
            if (StringUtils.hasText((String)search)) {
                stream = stream.filter(p -> p.getFileName().toString().contains(search));
            }
            Stream<PathMeta> metaStream = stream.map(p -> this.meta(this.getNormalizedPath((Path)p), (Path)p));
            if (null != sort) {
                metaStream = FileSystem.sort(metaStream, sort);
            }
            return metaStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createDirectories(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
    }

    private PathMeta meta(NormalizedPath normalizedPath, Path workingPath) {
        BasicFileAttributes attributes;
        if (Files.notExists(workingPath, new LinkOption[0])) {
            return null;
        }
        File file = workingPath.toFile();
        PathMeta meta = new PathMeta(normalizedPath);
        meta.setDirectory(file.isDirectory());
        if (file.isFile()) {
            meta.setSize(file.length());
        }
        try {
            attributes = Files.readAttributes(workingPath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        meta.setCreationTime(attributes.creationTime().toInstant());
        meta.setLastAccessTime(attributes.lastAccessTime().toInstant());
        meta.setLastModifiedTime(attributes.lastModifiedTime().toInstant());
        return meta;
    }
}

