/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.util;

import java.util.Random;
import me.insidezhou.southernquiet.util.IdGenerator;

public class SnowflakeIdGenerator
implements IdGenerator {
    public static final long EPOCH = 1517414400L;
    public static final int TimestampBits = 32;
    public static final int HighPaddingBits = 0;
    public static final int WorkerIdBits = 12;
    public static final int LowPaddingBits = 0;
    public static final int SequenceStartRange = 0;
    public static final int TickAccuracy = 1000;
    private Random random;
    private long epoch;
    private int sequenceStartRange;
    private int currentTimestampBits;
    private int currentHighPaddingBits;
    private int sequenceBits;
    private int workerId;
    private int currentTimeAccuracy;
    private int maxSequenceValue;
    private int workerIdShift;
    private int timestampShift;
    private int sequence = 0;
    private long lastTimestamp = -1L;

    public static int maxIntegerAtBits(int bits) {
        return ~(-1 << bits);
    }

    public SnowflakeIdGenerator(int workerId, int timestampBits, int highPaddingBits, int workerIdBits, int lowPaddingBits, long epoch, Random random, int sequenceStartRange, int tickAccuracy) {
        this.sequenceBits = 63 - timestampBits - highPaddingBits - workerIdBits - lowPaddingBits;
        this.currentTimestampBits = timestampBits;
        this.currentHighPaddingBits = highPaddingBits;
        this.currentTimeAccuracy = tickAccuracy;
        int maxWorkerId = SnowflakeIdGenerator.maxIntegerAtBits(workerIdBits);
        this.maxSequenceValue = SnowflakeIdGenerator.maxIntegerAtBits(this.sequenceBits);
        this.workerIdShift = this.sequenceBits + lowPaddingBits;
        this.timestampShift = this.sequenceBits + lowPaddingBits + workerIdBits + highPaddingBits;
        if (workerId > maxWorkerId || workerId < 0) {
            throw new IllegalArgumentException("worker Id can't be greater than maxWorkerId or less than 0, maxWorkerId=" + maxWorkerId);
        }
        this.random = random;
        this.epoch = epoch;
        this.sequenceStartRange = sequenceStartRange;
        this.workerId = workerId;
    }

    public SnowflakeIdGenerator(int workerId, int timestampBits, int highPaddingBits, int workerIdBits, int lowPaddingBits) {
        this(workerId, timestampBits, highPaddingBits, workerIdBits, lowPaddingBits, 1517414400L, null, 0, 1000);
    }

    public SnowflakeIdGenerator(int workerId, Random random, int sequenceStartRange) {
        this(workerId, 32, 0, 12, 0, 1517414400L, random, sequenceStartRange, 1000);
    }

    public SnowflakeIdGenerator(int workerId, long epoch) {
        this(workerId, 32, 0, 12, 0, epoch, null, 0, 1000);
    }

    public SnowflakeIdGenerator(int workerId) {
        this(workerId, 32, 0, 12, 0, 1517414400L, null, 0, 1000);
    }

    @Override
    public synchronized long generate() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id for ${lastTimestamp - timestamp} seconds");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1 & this.maxSequenceValue;
            if (0 == this.sequence) {
                timestamp = this.nextTick(this.lastTimestamp);
            }
        } else {
            this.sequence = null != this.random ? this.random.nextInt(this.sequenceStartRange) : this.sequenceStartRange;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.epoch << this.timestampShift | (long)(this.workerId << this.workerIdShift) | (long)this.sequence;
    }

    @Override
    public long getTimestampFromId(long id) {
        return (id >>> this.timestampShift) + 1517414400L;
    }

    @Override
    public long getWorkerFromId(long id) {
        return id << 1 + this.currentTimestampBits + this.currentHighPaddingBits >>> 1 + this.currentTimestampBits + this.currentHighPaddingBits + this.workerIdShift;
    }

    @Override
    public long getSequenceFromId(long id) {
        return id << 64 - this.sequenceBits >>> 64 - this.sequenceBits;
    }

    private long nextTick(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis() / (long)this.currentTimeAccuracy;
    }
}

