/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.filesystem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import org.springframework.util.StringUtils;

public class NormalizedPath
implements Serializable {
    private static final long serialVersionUID = -8700923055584230554L;
    public static final NormalizedPath ROOT = new NormalizedPath(FileSystem.PATH_SEPARATOR_STRING);
    private String[] parentNames = new String[0];
    private String name = "";

    public NormalizedPath(String path) {
        this.init(path);
    }

    public NormalizedPath(String[] pathElements) {
        if (0 == pathElements.length) {
            this.init(FileSystem.PATH_SEPARATOR_STRING);
            return;
        }
        this.init(String.join((CharSequence)FileSystem.PATH_SEPARATOR_STRING, pathElements));
    }

    private void init(String path) {
        List pathList = Arrays.stream((path = path.replace('\\', '/')).split(FileSystem.PATH_SEPARATOR_STRING)).filter(p -> !StringUtils.isEmpty((Object)p)).collect(Collectors.toList());
        if (0 == pathList.size()) {
            this.name = FileSystem.PATH_SEPARATOR_STRING;
        } else if (1 == pathList.size()) {
            this.setParentNames(new String[]{FileSystem.PATH_SEPARATOR_STRING});
            this.name = (String)pathList.get(0);
        } else {
            pathList.add(0, FileSystem.PATH_SEPARATOR_STRING);
            int lastIndex = pathList.size() - 1;
            this.setName((String)pathList.get(lastIndex));
            this.setParentNames(pathList.subList(0, lastIndex).toArray(new String[0]));
        }
    }

    public String[] getParentNames() {
        return this.parentNames;
    }

    public void setParentNames(String[] parentNames) {
        this.parentNames = parentNames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParent() {
        switch (this.parentNames.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this.parentNames[0];
            }
        }
        return String.join((CharSequence)FileSystem.PATH_SEPARATOR_STRING, this.parentNames).substring(1);
    }

    public NormalizedPath getParentPath() {
        return new NormalizedPath(this.getParentNames());
    }

    public String toString() {
        switch (this.parentNames.length) {
            case 0: {
                return this.name;
            }
            case 1: {
                return FileSystem.PATH_SEPARATOR_STRING + this.name;
            }
        }
        return String.join((CharSequence)FileSystem.PATH_SEPARATOR_STRING, this.parentNames).substring(1) + FileSystem.PATH_SEPARATOR_STRING + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NormalizedPath)) {
            return false;
        }
        NormalizedPath that = (NormalizedPath)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

