/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import me.insidezhou.southernquiet.filesystem.driver.LocalFileSystem;
import me.insidezhou.southernquiet.keyvalue.KeyValueStore;
import me.insidezhou.southernquiet.keyvalue.driver.FileSystemKeyValueStore;
import me.insidezhou.southernquiet.throttle.DefaultThrottleManager;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import me.insidezhou.southernquiet.throttle.annotation.ThrottleAnnotationBeanPostProcessor;
import me.insidezhou.southernquiet.util.AsyncRunner;
import me.insidezhou.southernquiet.util.Metadata;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.util.StringUtils;

@Configuration
@EnableAsync
@EnableConfigurationProperties
public class FrameworkAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="framework.key-value")
    @ConditionalOnMissingBean(value={KeyValueStore.class})
    public FileSystemKeyValueStore keyValueStore(KeyValueStoreProperties properties, FileSystem fileSystem) {
        return new FileSystemKeyValueStore(properties.getFileSystem(), fileSystem);
    }

    @Bean
    @ConditionalOnMissingBean(value={FileSystem.class})
    public LocalFileSystem fileSystem(LocalFileSystemProperties properties) {
        return new LocalFileSystem(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Metadata metadata(final Properties properties) {
        return new Metadata(){

            @Override
            public String getRuntimeId() {
                return StringUtils.hasText((String)properties.getRuntimeId()) ? properties.getRuntimeId() : this.getIPWithProcessId();
            }

            private String getIPWithProcessId() {
                String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                try {
                    return jvmName + "/" + InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    return jvmName;
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncRunner asyncRunner() {
        return new AsyncRunner();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework")
    public Properties frameworkProperties() {
        return new Properties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.event")
    public EventProperties eventProperties() {
        return new EventProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.file-system.local")
    public LocalFileSystemProperties localFileSystemProperties() {
        return new LocalFileSystemProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.key-value")
    public KeyValueStoreProperties keyValueStoreProperties() {
        return new KeyValueStoreProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ThrottleManager throttleManager() {
        return new DefaultThrottleManager();
    }

    @Bean
    public ThrottleAnnotationBeanPostProcessor throttleAnnotationBeanPostProcessor(ThrottleManager throttleManager) {
        return new ThrottleAnnotationBeanPostProcessor(throttleManager);
    }

    public static class KeyValueStoreProperties {
        private boolean enable = false;
        private FileSystem fileSystem = new FileSystem();

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public void setFileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        public static class FileSystem {
            private String workingRoot = "KEY_VALUE";
            private String nameSeparator = "__";

            public String getNameSeparator() {
                return this.nameSeparator;
            }

            public void setNameSeparator(String nameSeparator) {
                this.nameSeparator = nameSeparator;
            }

            public String getWorkingRoot() {
                return this.workingRoot;
            }

            public void setWorkingRoot(String workingRoot) {
                this.workingRoot = workingRoot;
            }
        }
    }

    public static class LocalFileSystemProperties {
        private String workingRoot = "${user.home}/.SQ_FILESYSTEM";

        public String getWorkingRoot() {
            return this.workingRoot;
        }

        public void setWorkingRoot(String workingRoot) {
            this.workingRoot = workingRoot;
        }
    }

    public static class EventProperties {
        private String[] defaultChannels = new String[]{"CHANNEL.PUBLIC"};

        public String[] getDefaultChannels() {
            return this.defaultChannels;
        }

        public void setDefaultChannels(String[] defaultChannels) {
            this.defaultChannels = defaultChannels;
        }
    }

    public static class Properties {
        private String runtimeId;

        public String getRuntimeId() {
            return this.runtimeId;
        }

        public void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }
    }
}

