/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.job.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.insidezhou.southernquiet.job.JobEngine;
import me.insidezhou.southernquiet.job.JobProcessor;
import me.insidezhou.southernquiet.job.driver.ProcessorNotFoundException;
import me.insidezhou.southernquiet.util.AsyncRunner;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractJobEngine<T>
implements JobEngine<T>,
ApplicationContextAware {
    protected Map<Class<T>, JobProcessor<T>> jobHandlerMap = new ConcurrentHashMap<Class<T>, JobProcessor<T>>();
    protected List<JobProcessor<T>> jobProcessorList = Collections.emptyList();
    protected AsyncRunner asyncRunner;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.jobProcessorList = new ArrayList(applicationContext.getBeansOfType(JobProcessor.class).values());
        this.asyncRunner = (AsyncRunner)applicationContext.getBean(AsyncRunner.class);
    }

    protected JobProcessor<T> getProcessor(T job) {
        Class<?> jobClass = job.getClass();
        JobProcessor<T> processor = this.jobHandlerMap.get(jobClass);
        if (null != processor) {
            return processor;
        }
        Optional<JobProcessor> optional = this.jobProcessorList.stream().filter(p -> {
            boolean matched;
            boolean bl = matched = p.getJobClass() == jobClass;
            if (matched) {
                this.jobHandlerMap.put(jobClass, (JobProcessor<T>)p);
            }
            return matched;
        }).limit(1L).findFirst();
        if (!optional.isPresent()) {
            optional = this.jobProcessorList.stream().filter(p -> {
                boolean matched = p.getJobClass().isAssignableFrom(jobClass);
                if (matched) {
                    this.jobHandlerMap.put(jobClass, (JobProcessor<T>)p);
                }
                return matched;
            }).limit(1L).findFirst();
        }
        return optional.orElseThrow(() -> new ProcessorNotFoundException(jobClass.getName()));
    }
}

