/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.keyvalue.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.FrameworkAutoConfiguration;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import me.insidezhou.southernquiet.filesystem.FileSystemException;
import me.insidezhou.southernquiet.filesystem.InvalidFileException;
import me.insidezhou.southernquiet.filesystem.PathMeta;
import me.insidezhou.southernquiet.filesystem.PathNotFoundException;
import me.insidezhou.southernquiet.keyvalue.KeyValueStore;
import org.springframework.util.SerializationUtils;
import org.springframework.util.StreamUtils;

public class FileSystemKeyValueStore
implements KeyValueStore {
    private final FileSystem fileSystem;
    private final String workingRoot;
    private final String nameSeparator;

    public FileSystemKeyValueStore(FrameworkAutoConfiguration.KeyValueStoreProperties.FileSystem properties, FileSystem fileSystem) {
        this.workingRoot = properties.getWorkingRoot();
        this.nameSeparator = properties.getNameSeparator();
        this.fileSystem = fileSystem;
    }

    @Override
    public <T extends Serializable> void put(String key, T value, int ttl) {
        try {
            this.fileSystem.put(this.getFilePath(key, ttl), this.serialize(value));
        }
        catch (InvalidFileException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Serializable> void set(String key, T value) {
        try {
            this.fileSystem.put(this.getFilePath(key, -1), this.serialize(value));
        }
        catch (InvalidFileException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Serializable> T get(String key) {
        try {
            int ttl;
            Optional<? extends PathMeta> opt = this.fileSystem.files(this.workingRoot, this.getKeyPrefix(key)).findFirst();
            if (!opt.isPresent()) return null;
            PathMeta meta = opt.get();
            String filename = meta.getName();
            long now = System.currentTimeMillis();
            long creationTime = meta.getCreationTime().toEpochMilli();
            if (creationTime + (long)(ttl = this.getTTLFromFileName(filename)) <= now) {
                return null;
            }
            try (InputStream inputStream = this.fileSystem.openReadStream(meta.getPath());){
                Serializable serializable = (Serializable)this.deserialize(inputStream);
                return (T)serializable;
            }
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (IOException | InvalidFileException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void touch(String key, Integer ttl) {
        block4: {
            try {
                Optional<? extends PathMeta> opt = this.fileSystem.files(this.workingRoot, this.getKeyPrefix(key)).findFirst();
                if (opt.isPresent()) {
                    PathMeta meta = opt.get();
                    this.fileSystem.touchCreation(meta.getPath());
                    if (null != ttl) {
                        this.fileSystem.move(meta.getPath(), this.getFilePath(key, ttl));
                    }
                    break block4;
                }
                throw new InvalidFileException("\u627e\u4e0d\u5230key\uff1a" + key);
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void remove(String ... keys) {
        Stream.of(keys).forEach(key -> {
            try {
                this.fileSystem.files(this.workingRoot, this.getKeyPrefix((String)key)).findFirst().ifPresent(meta -> this.fileSystem.delete(meta.getPath()));
            }
            catch (PathNotFoundException e) {
                return;
            }
        });
    }

    protected String getFileName(String key, int ttl) {
        return key + this.nameSeparator + Math.max(ttl, 0);
    }

    private String getKeyPrefix(String key) {
        return key + this.nameSeparator;
    }

    private String getFilePath(String key, int ttl) {
        return this.workingRoot + '/' + this.getFileName(key, ttl);
    }

    private int getTTLFromFileName(String name) {
        return Integer.parseInt(name.substring(name.indexOf(this.nameSeparator) + this.nameSeparator.length()));
    }

    private Stream<? extends PathMeta> getMetaStream() {
        try {
            return this.fileSystem.files(this.workingRoot);
        }
        catch (PathNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream serialize(Object data) {
        byte[] bytes = SerializationUtils.serialize((Object)data);
        return null == bytes ? null : new ByteArrayInputStream(bytes);
    }

    private Object deserialize(InputStream stream) {
        try {
            return SerializationUtils.deserialize((byte[])StreamUtils.copyToByteArray((InputStream)stream));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

