/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.notification;

import me.insidezhou.southernquiet.notification.NotificationSource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public interface NotificationPublisher<N> {
    default public void publish(N notification) {
        this.publish(notification, this.getNotificationSource(notification.getClass()));
    }

    public void publish(N var1, String var2);

    default public String getNotificationSource(Class<?> cls) {
        NotificationSource annotation = (NotificationSource)AnnotationUtils.getAnnotation(cls, NotificationSource.class);
        return null == annotation || StringUtils.isEmpty((Object)annotation.source()) ? cls.getSimpleName() : annotation.source();
    }

    default public String getExchange(String prefix, Class<?> cls) {
        return this.getExchange(prefix, this.getNotificationSource(cls));
    }

    default public String getExchange(String prefix, String source) {
        return prefix + "EXCHANGE." + source;
    }

    default public String getRouting(String prefix, Class<?> cls) {
        return this.getRouting(prefix, this.getNotificationSource(cls));
    }

    default public String getRouting(String prefix, String source) {
        return prefix + source;
    }
}

