/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle.annotation;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import me.insidezhou.southernquiet.throttle.Throttle;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.StringUtils;

public class ThrottleInterceptor
implements MethodInterceptor {
    private final ThrottleManager throttleManager;

    ThrottleInterceptor(ThrottleManager throttleManager) {
        this.throttleManager = throttleManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Throttle throttle;
        me.insidezhou.southernquiet.throttle.annotation.Throttle annotation = invocation.getMethod().getAnnotation(me.insidezhou.southernquiet.throttle.annotation.Throttle.class);
        String throttleName = annotation.throttleName();
        long threshold = annotation.threshold();
        TimeUnit[] timeUnits = annotation.timeUnit();
        if (StringUtils.isEmpty((Object)throttleName)) {
            Method method = invocation.getMethod();
            throttleName = method.getDeclaringClass().getName() + "#" + method.getName();
        }
        if (timeUnits.length > 0) {
            throttle = this.throttleManager.getTimeBased(throttleName);
            TimeUnit timeUnit = timeUnits[0];
            threshold = timeUnit.toMillis(threshold);
        } else {
            throttle = this.throttleManager.getCountBased(throttleName);
        }
        boolean open = throttle.open(threshold);
        if (open) {
            return invocation.proceed();
        }
        return null;
    }
}

