/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.auth;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.auth.Auth;
import me.insidezhou.southernquiet.auth.AuthContext;
import me.insidezhou.southernquiet.auth.AuthException;
import me.insidezhou.southernquiet.auth.AuthProvider;
import me.insidezhou.southernquiet.auth.Authentication;
import me.insidezhou.southernquiet.auth.AuthorizationFailException;
import me.insidezhou.southernquiet.auth.NoAuthProviderExistsException;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class AuthAdvice
implements MethodBeforeAdvice {
    public static final String AuthorizationMatcherQualifier = "AuthAdvice.AuthorizationMatcherQualifier";
    private final PathMatcher pathMatcher;
    private AuthProvider authProvider;

    public AuthAdvice(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public void before(@NotNull Method method, @NotNull Object[] args, Object target) throws AuthException {
        Assert.notNull((Object)target, (String)"\u8eab\u4efd\u53ca\u6743\u9650\u9a8c\u8bc1\u65f6\u76ee\u6807\u5bf9\u8c61\u4e0d\u8be5\u4e3anull");
        Auth methodAuthorization = (Auth)AnnotationUtils.getAnnotation((Method)method, Auth.class);
        Auth classAuthorization = (Auth)AnnotationUtils.getAnnotation(target.getClass(), Auth.class);
        Map<Auth.MatchMode, List<Auth>> groupedAuth = Stream.of(methodAuthorization, classAuthorization).filter(Objects::nonNull).collect(Collectors.groupingBy(Auth::mode));
        if (groupedAuth.isEmpty()) {
            return;
        }
        if (null == this.authProvider) {
            throw new NoAuthProviderExistsException();
        }
        Set allPermissions = groupedAuth.getOrDefault((Object)Auth.MatchMode.All, Collections.emptyList()).stream().flatMap(auth -> Arrays.stream(auth.permissions())).filter(permission -> !StringUtils.isEmpty((Object)permission)).collect(Collectors.toSet());
        Set anyPermissions = groupedAuth.getOrDefault((Object)Auth.MatchMode.Any, Collections.emptyList()).stream().flatMap(auth -> Arrays.stream(auth.permissions())).filter(permission -> !StringUtils.isEmpty((Object)permission)).collect(Collectors.toSet());
        if (allPermissions.isEmpty() && anyPermissions.isEmpty()) {
            return;
        }
        Authentication authentication = this.authProvider.getAuthentication(new AuthContext(method, args, target));
        Set<String> patterns = authentication.getPermissionPatterns();
        boolean permissionCheckPassed = allPermissions.stream().allMatch(permission -> patterns.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, permission)));
        boolean bl = permissionCheckPassed = permissionCheckPassed && (anyPermissions.isEmpty() || !patterns.isEmpty() && anyPermissions.stream().anyMatch(permission -> patterns.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, permission))));
        if (!permissionCheckPassed) {
            throw new AuthorizationFailException(patterns, Stream.concat(allPermissions.stream(), anyPermissions.stream()).collect(Collectors.toSet()));
        }
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Autowired(required=false)
    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }
}

