/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle.annotation;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import me.insidezhou.southernquiet.throttle.annotation.Throttle;
import me.insidezhou.southernquiet.throttle.annotation.ThrottleException;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ThrottleAdvice
implements MethodBeforeAdvice {
    private final ThrottleManager throttleManager;

    public ThrottleAdvice(ThrottleManager throttleManager) {
        this.throttleManager = throttleManager;
    }

    public void before(@NotNull Method method, @NotNull Object[] args, Object target) throws Throwable {
        me.insidezhou.southernquiet.throttle.Throttle throttle;
        Throttle annotation = (Throttle)AnnotationUtils.getAnnotation((Method)method, Throttle.class);
        String throttleName = Objects.requireNonNull(annotation).throttleName();
        long threshold = annotation.threshold();
        TimeUnit[] timeUnits = annotation.timeUnit();
        if (StringUtils.isEmpty((Object)throttleName)) {
            throttleName = method.getDeclaringClass().getName() + "#" + method.getName();
        }
        if (timeUnits.length > 0) {
            throttle = this.throttleManager.getTimeBased(throttleName);
            TimeUnit timeUnit = timeUnits[0];
            threshold = timeUnit.toMillis(threshold);
        } else {
            throttle = this.throttleManager.getCountBased(throttleName);
        }
        if (!throttle.open(threshold)) {
            throw new ThrottleException();
        }
    }
}

