/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.notification.driver;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import me.insidezhou.southernquiet.notification.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractNotificationListenerManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractNotificationListenerManager.class);
    protected final ApplicationContext applicationContext;

    public AbstractNotificationListenerManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Arrays.stream(this.applicationContext.getBeanDefinitionNames()).map(name -> {
            try {
                return this.applicationContext.getBean(name);
            }
            catch (BeansException e) {
                log.info("\u67e5\u627eNotificationListener\u65f6\uff0cbean\u672a\u80fd\u521d\u59cb\u5316: {}", name);
                return null;
            }
        }).filter(Objects::nonNull).forEach(bean -> Arrays.stream(ReflectionUtils.getAllDeclaredMethods(bean.getClass())).forEach(method -> AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)method, NotificationListener.class).forEach(listener -> {
            if (log.isDebugEnabled()) {
                log.debug("\u627e\u5230NotificationListener\uff1a{}(id={}) {}#{}", new Object[]{listener.notification().getSimpleName(), listener.name(), bean.getClass().getSimpleName(), method.getName()});
            }
            this.initListener((NotificationListener)listener, bean, (Method)method);
        })));
    }

    protected abstract void initListener(NotificationListener var1, Object var2, Method var3);
}

