/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import me.insidezhou.southernquiet.throttle.annotation.Throttle;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class ThrottleAdvice
implements MethodInterceptor {
    private final ThrottleManager throttleManager;

    public ThrottleAdvice(ThrottleManager throttleManager) {
        this.throttleManager = throttleManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        me.insidezhou.southernquiet.throttle.Throttle throttle;
        Method method = invocation.getMethod();
        Throttle annotation = (Throttle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Throttle.class);
        assert (annotation != null);
        String throttleName = annotation.name();
        long threshold = annotation.threshold();
        TimeUnit[] timeUnits = annotation.timeUnit();
        if (StringUtils.isEmpty((Object)throttleName)) {
            throttleName = method.getDeclaringClass().getName() + "#" + method.getName();
        }
        TimeUnit timeUnit = null;
        if (timeUnits.length > 0) {
            throttle = this.throttleManager.getTimeBased(throttleName);
            timeUnit = timeUnits[0];
            threshold = timeUnit.toMillis(threshold);
        } else {
            throttle = this.throttleManager.getCountBased(throttleName);
        }
        return throttle.open(threshold) ? invocation.proceed() : null;
    }
}

