/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import me.insidezhou.southernquiet.auth.AuthAdvice;
import me.insidezhou.southernquiet.auth.AuthAnnotationBeanPostProcessor;
import me.insidezhou.southernquiet.filesystem.FileSystem;
import me.insidezhou.southernquiet.filesystem.driver.LocalFileSystem;
import me.insidezhou.southernquiet.keyvalue.KeyValueStore;
import me.insidezhou.southernquiet.keyvalue.driver.FileSystemKeyValueStore;
import me.insidezhou.southernquiet.throttle.DefaultThrottleManager;
import me.insidezhou.southernquiet.throttle.ThrottleAdvice;
import me.insidezhou.southernquiet.throttle.ThrottleAnnotationBeanPostProcessor;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import me.insidezhou.southernquiet.util.AsyncRunner;
import me.insidezhou.southernquiet.util.Metadata;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties
public class FrameworkAutoConfiguration {
    public static final String ConfigRoot = "southern-quiet.framework";
    public static final String ConfigRoot_Auth = "southern-quiet.framework.auth";
    public static final String ConfigRoot_Throttle = "southern-quiet.framework.throttle";
    public static final String ConfigRoot_Event = "southern-quiet.framework.event";
    public static final String ConfigRoot_FileSystem = "southern-quiet.framework.file-system";
    public static final String ConfigRoot_KeyValue = "southern-quiet.framework.key-value";

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.key-value")
    @ConditionalOnMissingBean(value={KeyValueStore.class})
    public FileSystemKeyValueStore keyValueStore(KeyValueStoreProperties properties, FileSystem fileSystem) {
        return new FileSystemKeyValueStore(properties.getFileSystem(), fileSystem);
    }

    @Bean
    @ConditionalOnMissingBean(value={FileSystem.class})
    public LocalFileSystem fileSystem(LocalFileSystemProperties properties) {
        return new LocalFileSystem(properties);
    }

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.auth", matchIfMissing=true)
    @ConditionalOnMissingBean
    public AuthAnnotationBeanPostProcessor authBeanPostProcessor(AuthAdvice advice) {
        return new AuthAnnotationBeanPostProcessor(advice);
    }

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.auth", matchIfMissing=true)
    @ConditionalOnMissingBean
    public AuthAdvice authAdvice(@Qualifier(value="AuthAdvice.AuthorizationMatcherQualifier") PathMatcher pathMatcher) {
        return new AuthAdvice(pathMatcher);
    }

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.auth", matchIfMissing=true)
    @Qualifier(value="AuthAdvice.AuthorizationMatcherQualifier")
    public AntPathMatcher authorizationMatcher() {
        return new AntPathMatcher();
    }

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.throttle", matchIfMissing=true)
    @ConditionalOnMissingBean
    public ThrottleManager throttleManager() {
        return new DefaultThrottleManager();
    }

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.throttle", matchIfMissing=true)
    @ConditionalOnMissingBean
    public ThrottleAdvice throttleAdvice(ThrottleManager throttleManager, ConfigurableBeanFactory configurableBeanFactory) {
        return new ThrottleAdvice(throttleManager, configurableBeanFactory);
    }

    @Bean
    @ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.throttle", matchIfMissing=true)
    @ConditionalOnMissingBean
    public ThrottleAnnotationBeanPostProcessor throttleAnnotationBeanPostProcessor(ThrottleAdvice advice) {
        return new ThrottleAnnotationBeanPostProcessor(advice);
    }

    @Bean
    @ConditionalOnMissingBean
    public Metadata metadata(final Properties properties) {
        return new Metadata(){

            @Override
            public String getRuntimeId() {
                return StringUtils.hasText((String)properties.getRuntimeId()) ? properties.getRuntimeId() : this.getIPWithProcessId();
            }

            private String getIPWithProcessId() {
                String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                try {
                    return jvmName + "/" + InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    return jvmName;
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncRunner asyncRunner() {
        return new AsyncRunner();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework")
    public Properties frameworkProperties() {
        return new Properties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.event")
    public EventProperties eventProperties() {
        return new EventProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.file-system.local")
    public LocalFileSystemProperties localFileSystemProperties() {
        return new LocalFileSystemProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.key-value")
    public KeyValueStoreProperties keyValueStoreProperties() {
        return new KeyValueStoreProperties();
    }

    public static class KeyValueStoreProperties {
        private boolean enable = false;
        private FileSystem fileSystem = new FileSystem();

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public void setFileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        public static class FileSystem {
            private String workingRoot = "KEY_VALUE";
            private String nameSeparator = "__";

            public String getNameSeparator() {
                return this.nameSeparator;
            }

            public void setNameSeparator(String nameSeparator) {
                this.nameSeparator = nameSeparator;
            }

            public String getWorkingRoot() {
                return this.workingRoot;
            }

            public void setWorkingRoot(String workingRoot) {
                this.workingRoot = workingRoot;
            }
        }
    }

    public static class LocalFileSystemProperties {
        private String workingRoot = "${user.home}/.SQ_FILESYSTEM";

        public String getWorkingRoot() {
            return this.workingRoot;
        }

        public void setWorkingRoot(String workingRoot) {
            this.workingRoot = workingRoot;
        }
    }

    public static class EventProperties {
        private String[] defaultChannels = new String[]{"CHANNEL.PUBLIC"};

        public String[] getDefaultChannels() {
            return this.defaultChannels;
        }

        public void setDefaultChannels(String[] defaultChannels) {
            this.defaultChannels = defaultChannels;
        }
    }

    public static class Properties {
        private String runtimeId;

        public String getRuntimeId() {
            return this.runtimeId;
        }

        public void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }
    }
}

