/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.insidezhou.southernquiet.throttle.Throttle;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import me.insidezhou.southernquiet.util.Tuple;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.util.StringUtils;

public class ThrottleAdvice
implements MethodInterceptor {
    private final ThrottleManager throttleManager;
    private final ConfigurableBeanFactory configurableBeanFactory;
    private final Map<MethodInvocation, Tuple<String, Boolean, Long>> methodThrottle = new ConcurrentHashMap<MethodInvocation, Tuple<String, Boolean, Long>>();

    public ThrottleAdvice(ThrottleManager throttleManager, ConfigurableBeanFactory configurableBeanFactory) {
        this.throttleManager = throttleManager;
        this.configurableBeanFactory = configurableBeanFactory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Tuple<String, Boolean, Long> throttleValues = this.getThrottleValues(invocation);
        Throttle throttle = throttleValues.getSecond() != false ? this.throttleManager.getTimeBased(throttleValues.getFirst()) : this.throttleManager.getCountBased(throttleValues.getFirst());
        long threshold = throttleValues.getThird();
        return throttle.open(threshold) ? invocation.proceed() : null;
    }

    private Tuple<String, Boolean, Long> getThrottleValues(MethodInvocation invocation) {
        Tuple<String, Boolean, Long> throttleValues = this.methodThrottle.get(invocation);
        if (null != throttleValues) {
            return throttleValues;
        }
        Method method = invocation.getMethod();
        me.insidezhou.southernquiet.throttle.annotation.Throttle annotation = (me.insidezhou.southernquiet.throttle.annotation.Throttle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, me.insidezhou.southernquiet.throttle.annotation.Throttle.class);
        assert (annotation != null);
        String throttleName = annotation.name();
        long threshold = annotation.threshold();
        Optional<TimeUnit> optionalTimeUnit = Arrays.stream(annotation.timeUnit()).findFirst();
        Scheduled scheduledAnnotation = (Scheduled)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Scheduled.class);
        if (-1L == threshold && null != scheduledAnnotation) {
            Long thresholdFromSchedule = null;
            if (!StringUtils.isEmpty((Object)scheduledAnnotation.cron())) {
                String cron = this.configurableBeanFactory.resolveEmbeddedValue(scheduledAnnotation.cron());
                CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(Objects.requireNonNull(cron));
                Instant start = cronSequenceGenerator.next(Date.from(Instant.now())).toInstant();
                Instant end = cronSequenceGenerator.next(Date.from(start)).toInstant();
                thresholdFromSchedule = end.toEpochMilli() - start.toEpochMilli();
            } else if (scheduledAnnotation.fixedRate() > 0L) {
                thresholdFromSchedule = scheduledAnnotation.fixedRate();
            } else if (!StringUtils.isEmpty((Object)scheduledAnnotation.fixedRateString())) {
                thresholdFromSchedule = Duration.parse(scheduledAnnotation.fixedRateString()).toMillis();
            }
            if (null != thresholdFromSchedule) {
                optionalTimeUnit = Optional.of(TimeUnit.MILLISECONDS);
                threshold = (long)((double)thresholdFromSchedule.longValue() * 0.98);
            }
        }
        if (StringUtils.isEmpty((Object)throttleName)) {
            throttleName = method.getDeclaringClass().getName() + "#" + method.getName();
        }
        throttleValues = optionalTimeUnit.isPresent() ? new Tuple<String, Boolean, Long>(throttleName, true, optionalTimeUnit.get().toMillis(threshold)) : new Tuple<String, Boolean, Long>(throttleName, false, threshold);
        this.methodThrottle.put(invocation, throttleValues);
        return throttleValues;
    }
}

