/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.util;

import instep.util.LongIdGenerator;
import java.util.Random;
import me.insidezhou.southernquiet.util.IdGenerator;
import org.jetbrains.annotations.Nullable;

public class SnowflakeIdGenerator
extends LongIdGenerator
implements IdGenerator {
    public static final long EPOCH = 1517414400L;
    public static final int TimestampBits = 32;
    public static final int HighPaddingBits = 0;
    public static final int WorkerIdBits = 12;
    public static final int LowPaddingBits = 0;
    public static final int SequenceStartRange = 0;
    public static final int TickAccuracy = 1000;

    public SnowflakeIdGenerator(int workerId, int timestampBits, int highPaddingBits, int workerIdBits, int lowPaddingBits, long epoch, int sequenceStartRange, @Nullable Random random, int tickAccuracy) {
        super(workerId, timestampBits, highPaddingBits, workerIdBits, lowPaddingBits, epoch, sequenceStartRange, tickAccuracy, random);
    }

    public SnowflakeIdGenerator(int workerId, int timestampBits, int highPaddingBits, int workerIdBits, int lowPaddingBits) {
        this(workerId, timestampBits, highPaddingBits, workerIdBits, lowPaddingBits, 1517414400L, 0, new Random(), 1000);
    }

    public SnowflakeIdGenerator(int workerId, long epoch, int sequenceStartRange, int tickAccuracy) {
        this(workerId, 32, 0, 12, 0, epoch, sequenceStartRange, new Random(), tickAccuracy);
    }

    public SnowflakeIdGenerator(int workerId) {
        this(workerId, 32, 0, 12, 0, 1517414400L, 0, new Random(), 1000);
    }

    @Override
    public long getTicksFromId(long id) {
        return id >>> this.getTimestampShift();
    }

    @Override
    public long getTimestampFromId(long id) {
        return this.getTicksFromId(id) * (long)this.getTickAccuracy() + this.getEpochInMilliSeconds();
    }

    @Override
    public int getWorkerFromId(long id) {
        return (int)(id << 1 + this.getTimestampBits() + this.getHighPaddingBits() >>> 1 + this.getTimestampBits() + this.getHighPaddingBits() + this.getWorkerIdShift());
    }

    @Override
    public int getSequenceFromId(long id) {
        return (int)(id << 64 - this.getSequenceBits()) >>> 64 - this.getSequenceBits();
    }
}

