/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle;

import me.insidezhou.southernquiet.throttle.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeBasedThrottle
implements Throttle {
    private static final Logger log = LoggerFactory.getLogger(DefaultTimeBasedThrottle.class);
    private long lastOpenedAt = System.currentTimeMillis();

    @Override
    public synchronized boolean open(long threshold) {
        long now = System.currentTimeMillis();
        if (threshold <= 0L) {
            return this.reset(now);
        }
        if (log.isTraceEnabled()) {
            log.trace("throttled millis\tnow={}, lastOpenedAt={}, threshold={}, throttled={}", new Object[]{now, this.lastOpenedAt, threshold, now - this.lastOpenedAt});
        }
        if (now >= this.lastOpenedAt + threshold) {
            return this.reset(now);
        }
        return false;
    }

    private boolean reset(long openAt) {
        this.lastOpenedAt = openAt;
        return true;
    }
}

