/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.auth;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.auth.Auth;
import me.insidezhou.southernquiet.auth.AuthContext;
import me.insidezhou.southernquiet.auth.AuthException;
import me.insidezhou.southernquiet.auth.AuthProvider;
import me.insidezhou.southernquiet.auth.Authentication;
import me.insidezhou.southernquiet.auth.AuthorizationFailException;
import me.insidezhou.southernquiet.auth.NoAuthProviderExistsException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class AuthAdvice
implements MethodBeforeAdvice {
    private static final Logger log = LoggerFactory.getLogger(AuthAdvice.class);
    public static final String AuthorizationMatcherQualifier = "AuthAdvice.AuthorizationMatcherQualifier";
    private final PathMatcher pathMatcher;
    private AuthProvider authProvider;

    public AuthAdvice(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public void before(@NotNull Method method, @NotNull Object[] args, Object target) throws AuthException {
        Assert.notNull((Object)target, (String)"\u8eab\u4efd\u53ca\u6743\u9650\u9a8c\u8bc1\u65f6\u76ee\u6807\u5bf9\u8c61\u4e0d\u8be5\u4e3anull");
        Auth methodAuthorization = (Auth)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Auth.class);
        Auth classAuthorization = (Auth)AnnotatedElementUtils.findMergedAnnotation(target.getClass(), Auth.class);
        Map<Auth.MatchMode, Set> groupedPermissions = Stream.of(methodAuthorization, classAuthorization).filter(Objects::nonNull).collect(Collectors.groupingBy(Auth::mode)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().flatMap(auth -> Arrays.stream(auth.permissions())).collect(Collectors.toSet())));
        if (groupedPermissions.isEmpty()) {
            return;
        }
        if (null == this.authProvider) {
            throw new NoAuthProviderExistsException();
        }
        groupedPermissions = groupedPermissions.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set allPermissions = groupedPermissions.getOrDefault((Object)Auth.MatchMode.All, this.authProvider.getDefaultPermissionsForAllMode()).stream().filter(permission -> !StringUtils.isEmpty((Object)permission)).collect(Collectors.toSet());
        Set anyPermissions = groupedPermissions.getOrDefault((Object)Auth.MatchMode.Any, this.authProvider.getDefaultPermissionsForAnyMode()).stream().filter(permission -> !StringUtils.isEmpty((Object)permission)).collect(Collectors.toSet());
        if (allPermissions.isEmpty() && anyPermissions.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("permission required\tall={}, any={}", allPermissions, anyPermissions);
        }
        Authentication authentication = this.authProvider.getAuthentication(new AuthContext(method, args, target));
        Set<String> patterns = authentication.getPermissionPatterns();
        boolean permissionCheckPassed = allPermissions.stream().allMatch(permission -> patterns.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, permission)));
        boolean bl = permissionCheckPassed = permissionCheckPassed && (anyPermissions.isEmpty() || !patterns.isEmpty() && anyPermissions.stream().anyMatch(permission -> patterns.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, permission))));
        if (!permissionCheckPassed) {
            throw new AuthorizationFailException(patterns, Stream.concat(allPermissions.stream(), anyPermissions.stream()).collect(Collectors.toSet()));
        }
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Autowired(required=false)
    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }
}

