/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.debounce;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.insidezhou.southernquiet.debounce.Debounce;
import me.insidezhou.southernquiet.debounce.Debouncer;
import me.insidezhou.southernquiet.debounce.DebouncerProvider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.CachedExpressionEvaluator;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.util.StringUtils;

public class DebounceAdvice
implements MethodInterceptor {
    private final DebouncerProvider debouncerProvider;
    private final NameEvaluator nameEvaluator;

    public DebounceAdvice(DebouncerProvider debouncerProvider, BeanFactory beanFactory) {
        this.debouncerProvider = debouncerProvider;
        this.nameEvaluator = new NameEvaluator(beanFactory);
    }

    public Object invoke(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Debounce annotation = (Debounce)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Debounce.class);
        assert (annotation != null);
        String debouncerName = annotation.isSpELName() ? this.nameEvaluator.evalName(annotation.name(), invocation, annotation, new AnnotatedElementKey((AnnotatedElement)method, invocation.getThis().getClass())) : (StringUtils.isEmpty((Object)annotation.name()) ? DebounceAdvice.getDefaultDebouncerName(invocation, annotation) : annotation.name());
        Debouncer debouncer = this.debouncerProvider.getDebouncer(invocation, annotation.waitFor(), annotation.maxWaitFor(), debouncerName);
        debouncer.bounce();
        return null;
    }

    private static String getDefaultDebouncerName(MethodInvocation invocation, Debounce annotation) {
        return invocation.getThis().getClass().getName() + "#" + invocation.getMethod().getName() + "_" + annotation.waitFor() + "_" + annotation.maxWaitFor();
    }

    public static class EvaluationRoot {
        private Object instance;
        private Debounce annotation;
        private String defaultName;

        public EvaluationRoot(MethodInvocation invocation, Debounce annotation) {
            this.instance = invocation.getThis();
            this.annotation = annotation;
            this.defaultName = DebounceAdvice.getDefaultDebouncerName(invocation, annotation);
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public void setDefaultName(String defaultName) {
            this.defaultName = defaultName;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setInstance(Object instance) {
            this.instance = instance;
        }

        public Debounce getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(Debounce annotation) {
            this.annotation = annotation;
        }
    }

    public static class NameEvaluator
    extends CachedExpressionEvaluator {
        private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> expressionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>();
        private final BeanFactory beanFactory;

        public NameEvaluator(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public String evalName(String expression, MethodInvocation invocation, Debounce annotation, AnnotatedElementKey methodKey) {
            MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)new EvaluationRoot(invocation, annotation), invocation.getMethod(), invocation.getArguments(), this.getParameterNameDiscoverer());
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
            return (String)this.getExpression(this.expressionCache, methodKey, expression).getValue((EvaluationContext)evaluationContext, String.class);
        }
    }
}

