/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.debounce;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import me.insidezhou.southernquiet.debounce.Debouncer;
import me.insidezhou.southernquiet.debounce.DebouncerProvider;
import me.insidezhou.southernquiet.debounce.DefaultDebouncer;
import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import me.insidezhou.southernquiet.logging.SouthernQuietLoggerFactory;
import me.insidezhou.southernquiet.util.Pair;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.StringUtils;

public class DefaultDebouncerProvider
implements DebouncerProvider,
DisposableBean {
    private static final SouthernQuietLogger log = SouthernQuietLoggerFactory.getLogger(DefaultDebouncerProvider.class);
    private final ConcurrentMap<String, Pair<Debouncer, MethodInvocation>> debouncerAndInvocations = new ConcurrentHashMap<String, Pair<Debouncer, MethodInvocation>>();
    private final Future<?> future = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::invokeDebouncer, 7L, 7L, TimeUnit.MILLISECONDS);

    @Override
    public Debouncer getDebouncer(MethodInvocation invocation, long waitFor, long maxWaitFor, String debouncerName) {
        Object bean = invocation.getThis();
        Method method = invocation.getMethod();
        if (StringUtils.isEmpty((Object)debouncerName)) {
            debouncerName = bean.getClass().getName() + "#" + method.getName() + "_" + waitFor + "_" + maxWaitFor;
        }
        Pair pair = this.debouncerAndInvocations.computeIfAbsent(debouncerName, nm -> new Pair<DefaultDebouncer, MethodInvocation>(new DefaultDebouncer(waitFor, maxWaitFor), invocation));
        pair.setSecond(invocation);
        this.debouncerAndInvocations.put(debouncerName, pair);
        return (Debouncer)pair.getFirst();
    }

    private void invokeDebouncer() {
        this.debouncerAndInvocations.forEach((name, pair) -> {
            Debouncer debouncer = (Debouncer)pair.getFirst();
            MethodInvocation invocation = (MethodInvocation)pair.getSecond();
            if (debouncer.isStable()) {
                try {
                    invocation.proceed();
                }
                catch (Throwable throwable) {
                    log.message("\u65bd\u52a0\u4e86\u53bb\u6296\u52a8\u7684\u65b9\u6cd5\u6267\u884c\u5931\u8d25").context("debouncer", name).exception(throwable).error();
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.future.cancel(true);
        this.future.get();
    }
}

