/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.event.driver;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.FrameworkAutoConfiguration;
import me.insidezhou.southernquiet.event.EventPubSub;
import me.insidezhou.southernquiet.event.ShouldBroadcast;
import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import me.insidezhou.southernquiet.logging.SouthernQuietLoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractEventPubSub<E>
implements EventPubSub<E>,
InitializingBean,
ApplicationEventPublisherAware {
    private static final SouthernQuietLogger log = SouthernQuietLoggerFactory.getLogger(AbstractEventPubSub.class);
    public static final ConcurrentMap<String, Class<?>> EventTypeMap = new ConcurrentHashMap();
    private ApplicationEventPublisher applicationEventPublisher;
    private final FrameworkAutoConfiguration.EventProperties eventProperties;
    private final ApplicationContext applicationContext;
    private final String[] defaultChannel;
    private Set<String> listeningChannels;

    public AbstractEventPubSub(FrameworkAutoConfiguration.EventProperties eventProperties, ApplicationContext applicationContext) {
        this.defaultChannel = eventProperties.getDefaultChannels();
        this.eventProperties = eventProperties;
        this.applicationContext = applicationContext;
    }

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void publishToLocalOnly(E event) {
        this.applicationEventPublisher.publishEvent(event);
    }

    @Override
    public void publish(E event) {
        Class<?> eventClass = event.getClass();
        ShouldBroadcast annotation = (ShouldBroadcast)AnnotationUtils.getAnnotation(eventClass, ShouldBroadcast.class);
        if (null != annotation) {
            this.broadcast(event, this.getEventChannel(annotation), this.getEventTypeId(eventClass, annotation));
        } else {
            this.publishToLocalOnly(event);
        }
    }

    @Override
    public Set<String> getListeningChannels() {
        return this.listeningChannels;
    }

    protected String[] getEventChannel(ShouldBroadcast annotation) {
        return annotation.channels().length > 0 ? annotation.channels() : this.defaultChannel;
    }

    public String getEventTypeId(Class<?> eventClass, ShouldBroadcast annotation) {
        if (null != annotation && !StringUtils.isEmpty((Object)annotation.typeId())) {
            return annotation.typeId();
        }
        return eventClass.getSimpleName();
    }

    public void afterPropertiesSet() throws Exception {
        this.listeningChannels = Arrays.stream(this.applicationContext.getBeanDefinitionNames()).map(name -> {
            try {
                return this.applicationContext.getBean(name);
            }
            catch (BeansException e) {
                log.message("\u67e5\u627eEventListener\u65f6\uff0cbean\u672a\u80fd\u521d\u59cb\u5316").context("name", name).info();
                return null;
            }
        }).filter(Objects::nonNull).flatMap(bean -> {
            Stream channelsFromBeanMethods = Arrays.stream(ReflectionUtils.getAllDeclaredMethods(bean.getClass())).flatMap(method -> AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)method, EventListener.class).stream().flatMap(listener -> {
                log.message("\u627e\u5230EventListener").context(context -> {
                    context.put("listenerName", bean.getClass().getSimpleName());
                    context.put("method", method.getName());
                }).debug();
                return Arrays.stream(method.getParameterTypes());
            })).filter(parameterType -> !BeanUtils.isSimpleValueType((Class)parameterType)).flatMap(this::generateChannels);
            Stream<String> channelsFromBean = this.generateChannels(bean.getClass());
            return Stream.concat(channelsFromBeanMethods, channelsFromBean);
        }).collect(Collectors.toSet());
        this.listeningChannels.forEach(this::initChannel);
    }

    private Stream<String> generateChannels(Class<?> type) {
        ShouldBroadcast annotation = (ShouldBroadcast)AnnotationUtils.getAnnotation(type, ShouldBroadcast.class);
        if (null == annotation) {
            return Stream.empty();
        }
        String[] channels = 0 == annotation.channels().length ? this.eventProperties.getDefaultChannels() : annotation.channels();
        String typeId = this.getEventTypeId(type, annotation);
        EventTypeMap.put(typeId, type);
        log.message("\u5df2\u8ba2\u9605\u4e8b\u4ef6").context("typeId", typeId).context("channels", channels).context("event", type.getName()).info();
        return Arrays.stream(channels);
    }

    protected abstract void broadcast(E var1, String[] var2, String var3);

    protected void initChannel(String channel) {
    }
}

