/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.logging;

import java.util.HashMap;
import java.util.Map;
import me.insidezhou.southernquiet.logging.SouthernQuietLogFormatter;
import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import org.slf4j.LoggerFactory;

public abstract class SouthernQuietLoggerFactory {
    private static final Map<String, SouthernQuietLogger> southernQuietLoggers = new HashMap<String, SouthernQuietLogger>();
    private static SouthernQuietLogFormatter formatter = new SouthernQuietLogFormatter();

    public static void setFormatter(SouthernQuietLogFormatter formatter) {
        SouthernQuietLoggerFactory.formatter = formatter;
        southernQuietLoggers.values().forEach(logger -> logger.setFormatter(formatter));
    }

    public static synchronized SouthernQuietLogger getLogger(String name) {
        SouthernQuietLogger logger = southernQuietLoggers.computeIfAbsent(name, nm -> new SouthernQuietLogger(LoggerFactory.getLogger((String)nm), formatter));
        southernQuietLoggers.putIfAbsent(name, logger);
        return logger;
    }

    public static SouthernQuietLogger getLogger(Class<?> cls) {
        return SouthernQuietLoggerFactory.getLogger(cls.getName());
    }
}

