/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.debounce;

import me.insidezhou.southernquiet.debounce.Debouncer;
import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import me.insidezhou.southernquiet.logging.SouthernQuietLoggerFactory;

public class DefaultDebouncer
implements Debouncer {
    private static final SouthernQuietLogger log = SouthernQuietLoggerFactory.getLogger(DefaultDebouncer.class);
    private final long waitFor;
    private final long maxWaitFor;
    private long firstBounceAt = 0L;
    private long lastBounceAt = 0L;

    public DefaultDebouncer(long waitFor, long maxWaitFor) {
        this.waitFor = waitFor;
        this.maxWaitFor = maxWaitFor;
    }

    @Override
    public synchronized boolean isStable() {
        if (0L == this.firstBounceAt || 0L == this.lastBounceAt) {
            return false;
        }
        long now = System.currentTimeMillis();
        long interval = now - this.lastBounceAt;
        long maxWait = now - this.firstBounceAt;
        log.message("\u6b63\u5728\u68c0\u67e5\u6296\u52a8\u53bb\u9664\u60c5\u51b5").context(context -> {
            context.put("hashCode", this.hashCode());
            context.put("interval", interval);
            context.put("maxWait", maxWait);
        }).trace();
        if (interval >= this.waitFor || maxWait >= this.maxWaitFor) {
            return this.reset();
        }
        return false;
    }

    @Override
    public synchronized void bounce() {
        long now = System.currentTimeMillis();
        if (this.firstBounceAt <= 0L) {
            this.firstBounceAt = now;
        }
        this.lastBounceAt = now;
    }

    private synchronized boolean reset() {
        this.firstBounceAt = 0L;
        this.lastBounceAt = 0L;
        return true;
    }
}

