/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.job.driver;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import me.insidezhou.southernquiet.job.JobProcessor;
import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import me.insidezhou.southernquiet.logging.SouthernQuietLoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractJobProcessorManager
implements InitializingBean {
    private static final SouthernQuietLogger log = SouthernQuietLoggerFactory.getLogger(AbstractJobProcessorManager.class);
    protected final ApplicationContext applicationContext;

    public AbstractJobProcessorManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Arrays.stream(this.applicationContext.getBeanDefinitionNames()).map(name -> {
            try {
                return this.applicationContext.getBean(name);
            }
            catch (BeansException e) {
                log.message("\u67e5\u627eJobProcessor\u65f6\uff0cbean\u672a\u80fd\u521d\u59cb\u5316").context("name", name).info();
                return null;
            }
        }).filter(Objects::nonNull).forEach(bean -> Arrays.stream(ReflectionUtils.getAllDeclaredMethods(bean.getClass())).forEach(method -> AnnotationUtils.getRepeatableAnnotations((AnnotatedElement)method, JobProcessor.class).forEach(listener -> {
            log.message("\u627e\u5230JobProcessor").context(context -> {
                context.put("notification", listener.job().getSimpleName());
                context.put("name", listener.name());
                context.put("listenerName", bean.getClass().getSimpleName());
                context.put("method", method.getName());
            }).debug();
            this.initProcessor((JobProcessor)listener, bean, (Method)method);
        })));
    }

    protected abstract void initProcessor(JobProcessor var1, Object var2, Method var3);
}

