/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.logging;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.insidezhou.southernquiet.logging.SouthernQuietLogFormatter;
import me.insidezhou.southernquiet.util.Pair;
import org.slf4j.Logger;

public class SouthernQuietLogger {
    private final ThreadLocal<LogContext> logContextThreadLocal = ThreadLocal.withInitial(LogContext::new);
    private final Logger logger;
    private SouthernQuietLogFormatter formatter;

    public SouthernQuietLogger(Logger logger, SouthernQuietLogFormatter formatter) {
        this.logger = logger;
        this.formatter = formatter;
    }

    public SouthernQuietLogFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(SouthernQuietLogFormatter formatter) {
        this.formatter = formatter;
    }

    public SouthernQuietLogger exception(Throwable throwable) {
        LogContext logContext = this.logContextThreadLocal.get();
        logContext.throwable = throwable;
        return this;
    }

    public SouthernQuietLogger message(String msg) {
        LogContext logContext = this.logContextThreadLocal.get();
        logContext.message = msg;
        return this;
    }

    public SouthernQuietLogger context(String key, Supplier<Object> func) {
        LogContext logContext = this.logContextThreadLocal.get();
        logContext.context.put(key, func);
        return this;
    }

    public SouthernQuietLogger context(Consumer<Map<String, Object>> consumer) {
        LogContext logContext = this.logContextThreadLocal.get();
        consumer.accept(logContext.context);
        return this;
    }

    public SouthernQuietLogger context(String key, Object value) {
        LogContext logContext = this.logContextThreadLocal.get();
        logContext.context.put(key, value);
        return this;
    }

    public void trace() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isTraceEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        Pair<String, List<?>> pair2 = formatter.formatLogContext(logContext);
        this.logger.trace(pair2.getFirst(), pair2.getSecond().toArray());
        logContext.clear();
    }

    public void traceAsync() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isTraceEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        LogContext asyncContext = logContext.clone();
        logContext.clear();
        CompletableFuture.runAsync(() -> {
            Pair<String, List<?>> pair2 = formatter.formatLogContext(asyncContext);
            this.logger.trace(pair2.getFirst(), pair2.getSecond().toArray());
        });
    }

    public void debug() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isDebugEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        Pair<String, List<?>> pair2 = formatter.formatLogContext(logContext);
        this.logger.debug(pair2.getFirst(), pair2.getSecond().toArray());
        logContext.clear();
    }

    public void debugAsync() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isDebugEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        LogContext asyncContext = logContext.clone();
        logContext.clear();
        CompletableFuture.runAsync(() -> {
            Pair<String, List<?>> pair2 = formatter.formatLogContext(asyncContext);
            this.logger.debug(pair2.getFirst(), pair2.getSecond().toArray());
        });
    }

    public void info() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isInfoEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        Pair<String, List<?>> pair2 = formatter.formatLogContext(logContext);
        this.logger.info(pair2.getFirst(), pair2.getSecond().toArray());
        logContext.clear();
    }

    public void infoAsync() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isInfoEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        LogContext asyncContext = logContext.clone();
        logContext.clear();
        CompletableFuture.runAsync(() -> {
            Pair<String, List<?>> pair2 = formatter.formatLogContext(asyncContext);
            this.logger.info(pair2.getFirst(), pair2.getSecond().toArray());
        });
    }

    public void warn() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isWarnEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        Pair<String, List<?>> pair2 = formatter.formatLogContext(logContext);
        this.logger.warn(pair2.getFirst(), pair2.getSecond().toArray());
        logContext.clear();
    }

    public void warnAsync() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isWarnEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        LogContext asyncContext = logContext.clone();
        logContext.clear();
        CompletableFuture.runAsync(() -> {
            Pair<String, List<?>> pair2 = formatter.formatLogContext(asyncContext);
            this.logger.warn(pair2.getFirst(), pair2.getSecond().toArray());
        });
    }

    public void error() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isErrorEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        Pair<String, List<?>> pair2 = formatter.formatLogContext(logContext);
        this.logger.error(pair2.getFirst(), pair2.getSecond().toArray());
        logContext.clear();
    }

    public void errorAsync() {
        LogContext logContext = this.logContextThreadLocal.get();
        SouthernQuietLogFormatter formatter = this.formatter;
        if (!this.logger.isErrorEnabled() || null == formatter) {
            logContext.clear();
            return;
        }
        LogContext asyncContext = logContext.clone();
        logContext.clear();
        CompletableFuture.runAsync(() -> {
            Pair<String, List<?>> pair2 = formatter.formatLogContext(asyncContext);
            this.logger.error(pair2.getFirst(), pair2.getSecond().toArray());
        });
    }

    public static class LogContext
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 8228778036883035515L;
        private String message;
        private Throwable throwable;
        private Map<String, Object> context;

        public LogContext() {
            this.context = new LinkedHashMap<String, Object>();
        }

        public LogContext(String message, Throwable throwable, Map<String, Object> context) {
            this.message = message;
            this.throwable = throwable;
            this.context = new LinkedHashMap<String, Object>(context);
        }

        public LogContext clone() {
            return new LogContext(this.message, this.throwable, this.context);
        }

        public void clear() {
            this.message = null;
            this.throwable = null;
            this.context.clear();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public void setContext(Map<String, Object> context) {
            this.context = context;
        }
    }
}

