/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.insidezhou.southernquiet.throttle.Throttle;
import me.insidezhou.southernquiet.throttle.ThrottleManager;
import me.insidezhou.southernquiet.util.Tuple;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.CachedExpressionEvaluator;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ThrottleAdvice
implements MethodInterceptor,
EmbeddedValueResolverAware {
    private final ThrottleManager throttleManager;
    private StringValueResolver embeddedValueResolver;
    private final NameEvaluator nameEvaluator;
    private final Map<String, Tuple<String, Boolean, Long>> methodThrottle = new ConcurrentHashMap<String, Tuple<String, Boolean, Long>>();

    public ThrottleAdvice(ThrottleManager throttleManager, BeanFactory beanFactory) {
        this.throttleManager = throttleManager;
        this.nameEvaluator = new NameEvaluator(beanFactory);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Tuple<String, Boolean, Long> throttleValues = this.getThrottleValues(invocation);
        Throttle throttle = throttleValues.getSecond() != false ? this.throttleManager.getTimeBased(throttleValues.getFirst(), 1L) : this.throttleManager.getCountBased(throttleValues.getFirst());
        long threshold = throttleValues.getThird();
        return throttle.open(threshold) ? invocation.proceed() : null;
    }

    public int advisingCount() {
        return this.methodThrottle.size();
    }

    private Tuple<String, Boolean, Long> getThrottleValues(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        me.insidezhou.southernquiet.throttle.annotation.Throttle annotation = (me.insidezhou.southernquiet.throttle.annotation.Throttle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, me.insidezhou.southernquiet.throttle.annotation.Throttle.class);
        assert (annotation != null);
        String throttleName = annotation.isSpELName() ? this.nameEvaluator.evalName(annotation.name(), invocation, annotation, new AnnotatedElementKey((AnnotatedElement)method, invocation.getThis().getClass())) : (StringUtils.isEmpty((Object)annotation.name()) ? ThrottleAdvice.getDefaultThrottleName(invocation) : annotation.name());
        Tuple<String, Boolean, Long> throttleValues = this.methodThrottle.get(throttleName);
        if (null != throttleValues) {
            return throttleValues;
        }
        long threshold = annotation.threshold();
        Optional<TimeUnit> optionalTimeUnit = Arrays.stream(annotation.timeUnit()).findFirst();
        Scheduled scheduledAnnotation = (Scheduled)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Scheduled.class);
        if (-1L == threshold && null != scheduledAnnotation) {
            Long thresholdFromSchedule = null;
            if (!StringUtils.isEmpty((Object)scheduledAnnotation.cron())) {
                String cron = this.embeddedValueResolver.resolveStringValue(scheduledAnnotation.cron());
                CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(Objects.requireNonNull(cron));
                Instant start = cronSequenceGenerator.next(Date.from(Instant.now())).toInstant();
                Instant end = cronSequenceGenerator.next(Date.from(start)).toInstant();
                thresholdFromSchedule = end.toEpochMilli() - start.toEpochMilli();
            } else if (scheduledAnnotation.fixedRate() > 0L) {
                thresholdFromSchedule = scheduledAnnotation.fixedRate();
            } else if (!StringUtils.isEmpty((Object)scheduledAnnotation.fixedRateString())) {
                thresholdFromSchedule = Duration.parse(scheduledAnnotation.fixedRateString()).toMillis();
            }
            if (null != thresholdFromSchedule) {
                optionalTimeUnit = Optional.of(TimeUnit.MILLISECONDS);
                threshold = (long)((double)thresholdFromSchedule.longValue() * 0.98);
            }
        }
        throttleValues = optionalTimeUnit.isPresent() ? new Tuple<String, Boolean, Long>(throttleName, true, optionalTimeUnit.get().toMillis(threshold)) : new Tuple<String, Boolean, Long>(throttleName, false, threshold);
        this.methodThrottle.put(throttleName, throttleValues);
        return throttleValues;
    }

    private static String getDefaultThrottleName(MethodInvocation invocation) {
        return invocation.getThis().getClass().getName() + "#" + invocation.getMethod().getName();
    }

    public void setEmbeddedValueResolver(@NotNull StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public static class EvaluationRoot {
        private Object instance;
        private me.insidezhou.southernquiet.throttle.annotation.Throttle annotation;
        private String defaultName;

        public EvaluationRoot(MethodInvocation invocation, me.insidezhou.southernquiet.throttle.annotation.Throttle annotation) {
            this.instance = invocation.getThis();
            this.annotation = annotation;
            this.defaultName = ThrottleAdvice.getDefaultThrottleName(invocation);
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public void setDefaultName(String defaultName) {
            this.defaultName = defaultName;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setInstance(Object instance) {
            this.instance = instance;
        }

        public me.insidezhou.southernquiet.throttle.annotation.Throttle getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(me.insidezhou.southernquiet.throttle.annotation.Throttle annotation) {
            this.annotation = annotation;
        }
    }

    public static class NameEvaluator
    extends CachedExpressionEvaluator {
        private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> expressionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>();
        private final BeanFactory beanFactory;

        public NameEvaluator(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public String evalName(String expression, MethodInvocation invocation, me.insidezhou.southernquiet.throttle.annotation.Throttle annotation, AnnotatedElementKey methodKey) {
            MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)new EvaluationRoot(invocation, annotation), invocation.getMethod(), invocation.getArguments(), this.getParameterNameDiscoverer());
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
            return (String)this.getExpression(this.expressionCache, methodKey, expression).getValue((EvaluationContext)evaluationContext, String.class);
        }
    }
}

