/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.debounce;

import me.insidezhou.southernquiet.debounce.DebounceAdvice;
import me.insidezhou.southernquiet.debounce.DebouncePointcut;
import org.aopalliance.aop.Advice;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.debounce", matchIfMissing=true)
public class DebounceBeanPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor {
    private DebounceAdvice advice;

    public void setBeanFactory(@NotNull BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        DebouncePointcut pointcut = new DebouncePointcut();
        this.advice = new DebounceAdvice(beanFactory);
        this.advisor = new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.advice);
    }

    public DebounceAdvice getAdvice() {
        return this.advice;
    }
}

