/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.logging;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import me.insidezhou.southernquiet.util.Pair;
import org.springframework.util.StringUtils;

public class SouthernQuietLogFormatter {
    public Pair<String, List<?>> formatLogContext(SouthernQuietLogger.LogContext logContext) {
        String format = this.generateFormat(logContext);
        List<Object> parameters = this.generateParameters(logContext);
        String msg = logContext.getMessage();
        String result2 = this.combine(logContext, msg, format);
        return new Pair(result2, parameters);
    }

    protected String combine(SouthernQuietLogger.LogContext logContext, String msg, String format) {
        if (null != logContext.getThrowable()) {
            return msg + "\t" + format + "\n" + this.formatThrowable(logContext.getThrowable(), "");
        }
        return msg + "\t" + format;
    }

    protected String generateFormat(SouthernQuietLogger.LogContext logContext) {
        return logContext.getContext().keySet().stream().map(key -> key + "={}").collect(Collectors.joining(", "));
    }

    protected List<Object> generateParameters(SouthernQuietLogger.LogContext logContext) {
        return logContext.getContext().values().stream().map(v -> {
            if (v instanceof Supplier) {
                return ((Supplier)v).get();
            }
            return v;
        }).collect(Collectors.toList());
    }

    protected String formatThrowable(Throwable throwable, String indent) {
        if (null == throwable) {
            return "";
        }
        StringBuilder sb = new StringBuilder(throwable.toString());
        String currentIndent = indent + "\t";
        String stack = Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n" + currentIndent + "at "));
        String suppressed = Arrays.stream(throwable.getSuppressed()).map(t -> this.formatThrowable((Throwable)t, currentIndent)).collect(Collectors.joining("\n" + currentIndent + "at "));
        String cause = this.formatThrowable(throwable.getCause(), currentIndent);
        sb.append("\n").append(stack);
        if (StringUtils.hasText((String)suppressed)) {
            sb.append("\n").append(currentIndent).append("Suppressed: ").append(suppressed);
        }
        if (StringUtils.hasText((String)cause)) {
            sb.append("\n").append(currentIndent).append("Caused by: ").append(cause);
        }
        return sb.toString();
    }
}

