/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle;

import me.insidezhou.southernquiet.throttle.ThrottleAdvice;
import me.insidezhou.southernquiet.throttle.ThrottlePointcut;
import org.aopalliance.aop.Advice;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringValueResolver;

@Component
@ConditionalOnProperty(value={"enable"}, prefix="southern-quiet.framework.throttle", matchIfMissing=true)
public class ThrottleBeanPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor
implements EmbeddedValueResolverAware {
    private StringValueResolver stringValueResolver;
    private BeanFactory beanFactory;
    private ThrottleAdvice advice;

    public ThrottleAdvice getAdvice() {
        return this.advice;
    }

    public void setEmbeddedValueResolver(@NotNull StringValueResolver resolver) {
        this.stringValueResolver = resolver;
        this.setAdvisor();
    }

    public void setBeanFactory(@NotNull BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
        this.setAdvisor();
    }

    private void setAdvisor() {
        if (null == this.stringValueResolver) {
            return;
        }
        if (null == this.beanFactory) {
            return;
        }
        ThrottlePointcut pointcut = new ThrottlePointcut();
        this.advice = new ThrottleAdvice(this.beanFactory, this.stringValueResolver);
        this.advisor = new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.advice);
    }
}

