/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.filesystem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.stream.Stream;
import me.insidezhou.southernquiet.filesystem.FileSystemException;
import me.insidezhou.southernquiet.filesystem.InvalidFileException;
import me.insidezhou.southernquiet.filesystem.PathMeta;
import me.insidezhou.southernquiet.filesystem.PathMetaSort;
import me.insidezhou.southernquiet.filesystem.PathNotFoundException;
import org.springframework.util.StreamUtils;

public interface FileSystem {
    public static final char PATH_SEPARATOR = '/';
    public static final String PATH_SEPARATOR_STRING = String.valueOf('/');

    public static <T extends PathMeta> Stream<T> sort(Stream<T> stream, PathMetaSort sort) {
        switch (sort) {
            case Name: {
                return stream.sorted(Comparator.comparing(PathMeta::getName));
            }
            case NameDesc: {
                return stream.sorted(Comparator.comparing(PathMeta::getName).reversed());
            }
            case IsDirectory: {
                return stream.sorted(Comparator.comparing(PathMeta::isDirectory));
            }
            case IsDirectoryDesc: {
                return stream.sorted(Comparator.comparing(PathMeta::isDirectory).reversed());
            }
            case CreationTime: {
                return stream.sorted(Comparator.comparing(PathMeta::getCreationTime));
            }
            case CreationTimeDesc: {
                return stream.sorted(Comparator.comparing(PathMeta::getCreationTime).reversed());
            }
            case LastAccessTime: {
                return stream.sorted(Comparator.comparing(PathMeta::getLastAccessTime));
            }
            case LastAccessTimeDesc: {
                return stream.sorted(Comparator.comparing(PathMeta::getLastAccessTime).reversed());
            }
            case LastModifiedTime: {
                return stream.sorted(Comparator.comparing(PathMeta::getLastModifiedTime));
            }
            case LastModifiedTimeDesc: {
                return stream.sorted(Comparator.comparing(PathMeta::getLastModifiedTime).reversed());
            }
            case Size: {
                return stream.sorted(Comparator.comparing(PathMeta::getSize));
            }
            case SizeDesc: {
                return stream.sorted(Comparator.comparing(PathMeta::getSize).reversed());
            }
        }
        throw new RuntimeException();
    }

    public void createDirectory(String var1);

    public void put(String var1, InputStream var2) throws InvalidFileException;

    default public void put(String path, CharSequence txt) throws InvalidFileException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(txt.toString().getBytes(StandardCharsets.UTF_8));){
            this.put(path, byteArrayInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public boolean exists(String path) {
        return null != this.meta(path);
    }

    default public String read(String path) throws InvalidFileException {
        return this.read(path, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String read(String path, Charset charset) throws InvalidFileException {
        try (InputStream inputStream = this.openReadStream(path);){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)charset);
            return string;
        }
        catch (IOException e) {
            throw new InvalidFileException(path);
        }
    }

    public InputStream openReadStream(String var1) throws InvalidFileException;

    public OutputStream openWriteStream(String var1) throws InvalidFileException;

    default public void move(String source, String destination) throws FileSystemException {
        this.move(source, destination, false);
    }

    public void move(String var1, String var2, boolean var3) throws FileSystemException;

    default public void copy(String source, String destination) throws FileSystemException {
        this.copy(source, destination, false);
    }

    public void copy(String var1, String var2, boolean var3) throws FileSystemException;

    public void delete(String var1);

    public void touchCreation(String var1);

    public void touchLastModified(String var1);

    public void touchLastAccess(String var1);

    public <M extends PathMeta> M meta(String var1);

    default public Stream<? extends PathMeta> directories(String path) throws PathNotFoundException {
        return this.directories(path, "", false);
    }

    default public Stream<? extends PathMeta> directories(String path, boolean recursive) throws PathNotFoundException {
        return this.directories(path, "", recursive);
    }

    default public Stream<? extends PathMeta> directories(String path, String search) throws PathNotFoundException {
        return this.directories(path, search, false);
    }

    default public Stream<? extends PathMeta> directories(String path, String search, boolean recursive) throws PathNotFoundException {
        return this.directories(path, search, recursive, -1, -1, null);
    }

    public Stream<? extends PathMeta> directories(String var1, String var2, boolean var3, int var4, int var5, PathMetaSort var6) throws PathNotFoundException;

    default public Stream<? extends PathMeta> files(String path) throws PathNotFoundException {
        return this.files(path, "", false);
    }

    default public Stream<? extends PathMeta> files(String path, boolean recursive) throws PathNotFoundException {
        return this.files(path, "", recursive);
    }

    default public Stream<? extends PathMeta> files(String path, String search) throws PathNotFoundException {
        return this.files(path, search, false);
    }

    default public Stream<? extends PathMeta> files(String path, String search, boolean recursive) throws PathNotFoundException {
        return this.files(path, search, recursive, -1, -1, null);
    }

    public Stream<? extends PathMeta> files(String var1, String var2, boolean var3, int var4, int var5, PathMetaSort var6) throws PathNotFoundException;

    public void createSymbolicLink(String var1, String var2) throws InvalidFileException;
}

