/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.throttle;

import me.insidezhou.southernquiet.logging.SouthernQuietLogger;
import me.insidezhou.southernquiet.logging.SouthernQuietLoggerFactory;
import me.insidezhou.southernquiet.throttle.Throttle;

public class DefaultTimeBasedThrottle
implements Throttle {
    private static final SouthernQuietLogger log = SouthernQuietLoggerFactory.getLogger(DefaultTimeBasedThrottle.class);
    private Long lastOpenedAt;
    private long openedCount = 0L;
    private final long countDelay;

    public DefaultTimeBasedThrottle(long countDelay) {
        this.countDelay = countDelay;
        if (0L == countDelay) {
            this.lastOpenedAt = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized boolean open(long threshold) {
        long now = System.currentTimeMillis();
        if (this.openedCount++ < this.countDelay) {
            if (this.openedCount == this.countDelay) {
                this.lastOpenedAt = now;
            }
            return true;
        }
        if (threshold <= 0L) {
            return this.reset(now);
        }
        log.message("throttled millis").context("now", now).context("lastOpenedAt", this.lastOpenedAt).context("threshold", threshold).context("throttled", now - this.lastOpenedAt).trace();
        if (now >= this.lastOpenedAt + threshold) {
            return this.reset(now);
        }
        return false;
    }

    private boolean reset(long openAt) {
        this.lastOpenedAt = openAt;
        return true;
    }
}

