/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.job.driver;

import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import me.insidezhou.southernquiet.amqp.rabbit.AmqpAutoConfiguration;
import me.insidezhou.southernquiet.job.AmqpJobAutoConfiguration;
import me.insidezhou.southernquiet.job.JobProcessor;
import me.insidezhou.southernquiet.job.driver.AbstractJobEngine;
import me.insidezhou.southernquiet.job.driver.AmqpJobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;

public class AmqpJobEngine<T extends Serializable>
extends AbstractJobEngine<T> {
    private static final Logger log = LoggerFactory.getLogger(AmqpJobEngine.class);
    private RabbitTemplate rabbitTemplate;
    private AmqpAdmin amqpAdmin;
    private AmqpJobAutoConfiguration.Properties properties;

    public AmqpJobEngine(MessageConverter messageConverter, AmqpAdmin amqpAdmin, AmqpJobAutoConfiguration.Properties properties, RabbitProperties rabbitProperties, RabbitConnectionFactoryBean factoryBean, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) {
        this.amqpAdmin = amqpAdmin;
        this.properties = properties;
        CachingConnectionFactory connectionFactory = AmqpAutoConfiguration.rabbitConnectionFactory((RabbitProperties)rabbitProperties, (RabbitConnectionFactoryBean)factoryBean, connectionNameStrategy);
        connectionFactory.setPublisherConfirms(false);
        RabbitTemplate rabbitTemplate = new RabbitTemplate((ConnectionFactory)connectionFactory);
        rabbitTemplate.setMessageConverter(messageConverter);
        rabbitTemplate.setChannelTransacted(true);
        this.rabbitTemplate = rabbitTemplate;
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    @PostConstruct
    public void init() {
        HashMap<String, String> deadQueueArgs = new HashMap<String, String>();
        deadQueueArgs.put("x-dead-letter-exchange", "");
        deadQueueArgs.put("x-dead-letter-routing-key", this.properties.getWorkingQueue());
        Queue deadQueue = new Queue(this.properties.getDeadJobQueue(), true, false, false, deadQueueArgs);
        this.amqpAdmin.declareQueue(new Queue(this.properties.getWorkingQueue()));
        this.amqpAdmin.declareQueue(deadQueue);
        DirectExchange deadExchange = new DirectExchange(this.properties.getDeadJobExchange());
        Binding deadBinding = BindingBuilder.bind((Queue)deadQueue).to((Exchange)deadExchange).with(this.properties.getDeadJobQueue()).noargs();
        this.amqpAdmin.declareExchange((Exchange)deadExchange);
        this.amqpAdmin.declareBinding(deadBinding);
    }

    public void arrange(T job) {
        this.rabbitTemplate.convertAndSend(this.properties.getWorkingQueue(), job, message -> {
            MessageProperties properties = message.getMessageProperties();
            properties.setDeliveryMode(MessageDeliveryMode.PERSISTENT);
            return message;
        });
    }

    public void process(Message message) throws Exception {
        Serializable job = (Serializable)this.rabbitTemplate.getMessageConverter().fromMessage(message);
        JobProcessor processor = this.getProcessor(job);
        processor.process((Object)job);
    }

    public static class Listener
    implements AmqpJobListener {
        private AmqpJobEngine jobEngine;

        public Listener(AmqpJobEngine jobEngine) {
            this.jobEngine = jobEngine;
        }

        @Override
        public void process(Message message) throws Exception {
            this.jobEngine.process(message);
        }
    }
}

