/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.job;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import me.insidezhou.southernquiet.amqp.rabbit.AmqpAutoConfiguration;
import me.insidezhou.southernquiet.amqp.rabbit.AmqpMessageRecover;
import me.insidezhou.southernquiet.amqp.rabbit.DirectRabbitListenerContainerFactoryConfigurer;
import me.insidezhou.southernquiet.job.driver.AmqpJobEngine;
import me.insidezhou.southernquiet.job.driver.AmqpJobListener;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableRabbit
@EnableTransactionManagement(proxyTargetClass=true)
@Configuration
@EnableConfigurationProperties
public class AmqpJobAutoConfiguration {
    public static final String AmqpJobListenerContainerFactory = "amqpJobListenerContainerFactory";

    @Bean
    @ConditionalOnMissingBean
    public AmqpJobEngine amqpJobEngine(MessageConverter messageConverter, AmqpAdmin amqpAdmin, Properties properties, RabbitProperties rabbitProperties, RabbitConnectionFactoryBean factoryBean, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) {
        return new AmqpJobEngine(messageConverter, amqpAdmin, properties, rabbitProperties, factoryBean, connectionNameStrategy);
    }

    @Bean(value={"amqpJobListenerContainerFactory"})
    @ConditionalOnMissingBean
    public DirectRabbitListenerContainerFactory amqpJobListenerContainerFactory(MessageConverter messageConverter, AmqpAutoConfiguration.Properties amqpProperties, Properties properties, RabbitProperties rabbitProperties, RabbitConnectionFactoryBean factoryBean, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy, AmqpAdmin amqpAdmin, AmqpJobEngine jobEngine) {
        CachingConnectionFactory cachingConnectionFactory = AmqpAutoConfiguration.rabbitConnectionFactory((RabbitProperties)rabbitProperties, (RabbitConnectionFactoryBean)factoryBean, connectionNameStrategy);
        DirectRabbitListenerContainerFactoryConfigurer containerFactoryConfigurer = new DirectRabbitListenerContainerFactoryConfigurer(rabbitProperties, (MessageRecoverer)new AmqpMessageRecover((AmqpTemplate)jobEngine.getRabbitTemplate(), amqpAdmin, properties.getDeadJobExchange(), properties.getDeadJobQueue(), amqpProperties), amqpProperties);
        DirectRabbitListenerContainerFactory factory = new DirectRabbitListenerContainerFactory();
        factory.setMessageConverter(messageConverter);
        factory.setAcknowledgeMode(amqpProperties.getAcknowledgeMode());
        containerFactoryConfigurer.configure(factory, (ConnectionFactory)cachingConnectionFactory);
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public AmqpJobListener amqpJobListener(AmqpJobEngine jobEngine) {
        return new AmqpJobEngine.Listener(jobEngine);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.job.amqp")
    public Properties amqpJobProperties() {
        return new Properties();
    }

    public static class Properties {
        private String workingQueue = "JOB.WORKING-QUEUE";
        private String containerFactoryBeanName = "amqpJobListenerContainerFactory";
        private String deadJobExchange = "";
        private String deadJobQueue = "JOB.DEAD-QUEUE";
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration jobTTL = Duration.ofHours(1L);

        public String getWorkingQueue() {
            return this.workingQueue;
        }

        public void setWorkingQueue(String workingQueue) {
            this.workingQueue = workingQueue;
        }

        public String getContainerFactoryBeanName() {
            return this.containerFactoryBeanName;
        }

        public void setContainerFactoryBeanName(String containerFactoryBeanName) {
            this.containerFactoryBeanName = containerFactoryBeanName;
        }

        public String getDeadJobExchange() {
            return this.deadJobExchange;
        }

        public void setDeadJobExchange(String deadJobExchange) {
            this.deadJobExchange = deadJobExchange;
        }

        public String getDeadJobQueue() {
            return this.deadJobQueue;
        }

        public void setDeadJobQueue(String deadJobQueue) {
            this.deadJobQueue = deadJobQueue;
        }

        public Duration getJobTTL() {
            return this.jobTTL;
        }

        public void setJobTTL(Duration jobTTL) {
            this.jobTTL = jobTTL;
        }
    }
}

