/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.job;

import me.insidezhou.southernquiet.amqp.rabbit.AmqpAutoConfiguration;
import me.insidezhou.southernquiet.job.driver.AmqpJobArranger;
import me.insidezhou.southernquiet.job.driver.AmqpJobProcessorManager;
import me.insidezhou.southernquiet.util.Amplifier;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.transaction.RabbitTransactionManager;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableRabbit
@EnableTransactionManagement
@Configuration
@EnableConfigurationProperties
@AutoConfigureAfter(value={RabbitAutoConfiguration.class, AmqpAutoConfiguration.class})
public class AmqpJobAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public RabbitTransactionManager rabbitTransactionManager(RabbitProperties rabbitProperties, RabbitConnectionFactoryBean factoryBean, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) {
        return new RabbitTransactionManager((ConnectionFactory)AmqpAutoConfiguration.rabbitConnectionFactory((RabbitProperties)rabbitProperties, (RabbitConnectionFactoryBean)factoryBean, connectionNameStrategy));
    }

    @Bean
    @ConditionalOnMissingBean
    public AmqpJobArranger amqpJobArranger(SmartMessageConverter messageConverter, Properties jobProperties, RabbitTransactionManager transactionManager) {
        return new AmqpJobArranger(messageConverter, jobProperties, transactionManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public AmqpJobProcessorManager amqpJobProcessorManager(RabbitAdmin rabbitAdmin, @Qualifier(value="AmqpAutoConfiguration.RecoverAmplifierQualifier") Amplifier amplifier, AmqpJobArranger<?> jobArranger, Properties amqpJobProperties, AmqpAutoConfiguration.Properties amqpProperties, RabbitProperties rabbitProperties, RabbitTransactionManager transactionManager, ApplicationContext applicationContext) {
        return new AmqpJobProcessorManager(rabbitAdmin, jobArranger, amplifier, amqpJobProperties, amqpProperties, transactionManager, rabbitProperties, applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="southern-quiet.framework.job.amqp")
    public Properties amqpJobProperties() {
        return new Properties();
    }

    public static class Properties {
        private String namePrefix = "JOB.";

        public String getNamePrefix() {
            return this.namePrefix;
        }

        public void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }
    }
}

