/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.job.driver;

import me.insidezhou.southernquiet.amqp.rabbit.AbstractAmqpJobArranger;
import me.insidezhou.southernquiet.job.AmqpJobAutoConfiguration;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.transaction.RabbitTransactionManager;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.context.Lifecycle;

public class AmqpJobArranger<J>
extends AbstractAmqpJobArranger<J>
implements Lifecycle {
    private final RabbitTemplate rabbitTemplate;
    private final SmartMessageConverter messageConverter;
    private final AmqpJobAutoConfiguration.Properties jobProperties;

    public AmqpJobArranger(SmartMessageConverter messageConverter, AmqpJobAutoConfiguration.Properties jobProperties, RabbitTransactionManager transactionManager) {
        this.messageConverter = messageConverter;
        this.jobProperties = jobProperties;
        RabbitTemplate rabbitTemplate = new RabbitTemplate(transactionManager.getConnectionFactory());
        rabbitTemplate.setMessageConverter((MessageConverter)messageConverter);
        rabbitTemplate.setChannelTransacted(true);
        this.rabbitTemplate = rabbitTemplate;
    }

    public void arrange(J job, int delay) {
        String prefix = this.jobProperties.getNamePrefix();
        String source = AmqpJobArranger.getQueueSource(job.getClass());
        String routing = AmqpJobArranger.getRouting((String)prefix, (String)source);
        String delayedRouting = AmqpJobArranger.getDelayRouting((String)prefix, (String)source);
        MessagePostProcessor messagePostProcessor = message -> {
            MessageProperties properties = message.getMessageProperties();
            properties.setDeliveryMode(MessageDeliveryMode.PERSISTENT);
            if (delay > 0) {
                properties.setDelay(Integer.valueOf(delay));
            }
            return message;
        };
        this.rabbitTemplate.convertAndSend(delay > 0 ? delayedRouting : routing, delay > 0 ? delayedRouting : routing, job, messagePostProcessor);
    }

    public SmartMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void start() {
        this.rabbitTemplate.start();
    }

    public void stop() {
        this.rabbitTemplate.stop();
    }

    public boolean isRunning() {
        return this.rabbitTemplate.isRunning();
    }
}

