/*
 * Decompiled with CFR 0.152.
 */
package me.juancarlosganzo.lcc;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import me.juancarlosganzo.lcc.LinecaCapturaCerradaException;
import me.juancarlosganzo.lcc.dto.InformacionPago;

public class LineaCapturaCerrada {
    public String generar(InformacionPago infoPago) throws LinecaCapturaCerradaException {
        String lcc = "";
        lcc = this.validarServicio(infoPago.getServicio()) + this.CondensarFechaOperacion(infoPago.getFechaOperacion()) + this.validadConsecutivo(infoPago.getConsecutivo()) + this.condensarFechaVencimiento(infoPago.getFechaExpiracion()) + this.condensarImporte(infoPago.getMonto());
        lcc = lcc + 2;
        lcc = lcc + this.ValidarLineaCaptura(lcc);
        return lcc;
    }

    private String condensarImporte(BigDecimal importe) {
        int[] serie = new int[]{7, 3, 1};
        int suma = 0;
        int k = 0;
        String convert = String.valueOf(importe);
        char[] importTexto = convert.toCharArray();
        for (int i = convert.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(importTexto[i])) continue;
            int j = Character.getNumericValue(importTexto[i]);
            suma += j * serie[k];
            k = k == 2 ? 0 : k + 1;
        }
        return String.valueOf(suma % 10);
    }

    private String ValidarLineaCaptura(String lc) {
        String llaves;
        String serie = "1113171923";
        long suma = 0L;
        int k = 0;
        char[] lcc = lc.toCharArray();
        for (int i = lcc.length - 1; i >= 0; --i) {
            if (!Character.isDigit(lcc[i])) continue;
            String sub = serie.substring(k, k + 2);
            int substr = Integer.parseInt(sub);
            long a = Character.getNumericValue(lcc[i]);
            suma += a * (long)substr;
            k = k == 8 ? 0 : k + 2;
        }
        long llave = suma % 97L;
        if ((llaves = String.valueOf(++llave)).length() < 2) {
            return "0" + llaves;
        }
        return llaves;
    }

    private String condensarFechaVencimiento(Date fechaVencimiento) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.setTime(fechaVencimiento);
        int anyo = calendario.get(1);
        int mes = calendario.get(2) + 1;
        int dia = calendario.get(5);
        int llaveAnyo = (anyo - 2013) * 372;
        int llaveMes = (mes - 1) * 31;
        int llaveDia = dia - 1;
        return String.valueOf(llaveAnyo + llaveMes + llaveDia);
    }

    private String CondensarFechaOperacion(Date fechaOperacion) {
        String fechaCondensada = new SimpleDateFormat("yyMM").format(fechaOperacion);
        return fechaCondensada;
    }

    private String validadConsecutivo(int consecutivo) throws LinecaCapturaCerradaException {
        if (consecutivo < 0) {
            throw new LinecaCapturaCerradaException("El valor minimo para el servicio es de 0");
        }
        if (consecutivo > 999999) {
            throw new LinecaCapturaCerradaException("El valor maximo para el servicio es de 99");
        }
        String consecutivoValor = String.valueOf(consecutivo);
        int digitosPendientes = 6 - consecutivoValor.length();
        for (int i = 0; i < digitosPendientes; ++i) {
            consecutivoValor = "0" + consecutivoValor;
        }
        return consecutivoValor;
    }

    private String validarServicio(int servicio) throws LinecaCapturaCerradaException {
        if (servicio < 0) {
            throw new LinecaCapturaCerradaException("El valor minimo para el servicio es de 0");
        }
        if (servicio > 99) {
            throw new LinecaCapturaCerradaException("El valor maximo para el servicio es de 99");
        }
        String idServicio = String.valueOf(servicio);
        if (idServicio.length() < 2) {
            idServicio = "0" + idServicio;
        }
        return idServicio;
    }
}

