package me.karboom.mold;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class Rule {
	private Object _valid;

	// 标记X的变量互斥，设置的时候，就清空另外的
	// X
	private HashMap<String, Rule> _object;
	private String _regex;
	// X
	private List<Rule> _array;

	/**
	 * 只放行允许的值
	 */
	public Rule valid(Object input) {
		_valid = input;
		return this;
	}

	public Rule object(HashMap<String, Rule> object) {
		this._object = object;
		return this;
	}

	public Rule array(List<Rule> array) {
		this._array = array;
		return this;
	}

	public Rule error(String str) {
		return this;
	}

	public Rule error(Function func) {
		return this;
	}

	public Rule regex(String input) {
		this._regex = input;
		return this;
	}

	public Rule date() {
		return regex("^\\d{4}-\\d{2}-\\d{2}(\\s\\d{2}:\\d{2}:\\d{2})?$");
	}

	/**
	 * 最大长度限制
	 * @return
	 */
	public Rule maxLen() {
		return this;
	}

	/**
	 * 最小长度限制
	 * @return
	 */
	public Rule minLen() {
		return this;
	}

	/**
	 * 最大数值限制
	 */
	public Rule maxVal() {return this;}

	/**
	 * 最小数值限制
	 */
	public Rule minVal() {return this;}

	public Result _validate(Object target) {
		if (_array != null) {
			if (!(target instanceof List))	{
				return new Result(){{
					setSuccess(false);
					setMessage("");
				}};
			}
		}

		if (_object != null) {
			Field[] fields = target.getClass().getDeclaredFields();

			if (fields.length != _object.keySet().size()) {
				return new Result(){{
					setSuccess(false);
					setMessage("");
				}};
			}

			for (String key: _object.keySet()) {
				var rule = _object.get(key);
				Object value = null;

				// 遍历字段并将它们存储在HashMap中
				for (Field field : fields) {
					field.setAccessible(true); // 设置字段可访问

					try {
						// 获取字段的名称和值，并存储在HashMap中
						String fieldName = field.getName();
						if (fieldName.equals(key)) {
							value = field.get(target);
						}
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				}

				// 如果预期的字段没找到，直接报错
				if (value == null) {
					return new Result(){{
						setSuccess(false);
						setMessage("");
					}};
				}

				var res = rule._validate(value);
				if (!res.success) {
					return new Result(){{
						setSuccess(false);
						setMessage("");
					}};
				}
			}
		}

		if (_valid != null) {
			if (_valid instanceof List) {
				if (!((List<?>) _valid).contains(target)) {
					return new Result(){{
						setSuccess(false);
						setMessage("");
					}};
				}
			} else if (_valid instanceof Class && ((Class) _valid).isEnum()){
				// 处理枚举逻辑
				var match = false;
				for (var field : ((Class<?>) _valid).getDeclaredFields()) {
					if (field.isEnumConstant()) {
						if (field.getName().toString().equals((String) target)) {
							match = true;
						}
					}
				}

				if (!match) {
					return new Result(){{
						setSuccess(false);
						setMessage("");
					}};
				}
			} else {
				throw new RuntimeException("valid只允许List、Enum");
			}
		}

		if (_regex != null) {
			if (target instanceof String) {
				var res = ((String) target).matches(_regex);
				if (!res) {
					return new Result(){{
						setSuccess(false);
						setMessage("");
					}};
				}
			} else {
				return new Result(){{
					setSuccess(false);
					setMessage("");
				}};
			}
		}

		return new Result(){{
			setSuccess(true);
			setMessage("");
		}};
	}
	public Result verify(Object target) {
		var res = _validate(target);
		return res;
	}
}
