/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.example.uiwidget.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DrawableTextView
extends AppCompatTextView {
    private Drawable[] drawables = new Drawable[4];
    private int[] widths = new int[4];
    private int[] heights = new int[4];
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;

    public DrawableTextView(Context context) {
        this(context, null);
    }

    public DrawableTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public DrawableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setGravity(17);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.DrawableTextView);
        this.drawables[0] = array.getDrawable(R.styleable.DrawableTextView_leftDrawable);
        this.drawables[1] = array.getDrawable(R.styleable.DrawableTextView_topDrawable);
        this.drawables[2] = array.getDrawable(R.styleable.DrawableTextView_rightDrawable);
        this.drawables[3] = array.getDrawable(R.styleable.DrawableTextView_bottomDrawable);
        this.widths[0] = array.getDimensionPixelSize(R.styleable.DrawableTextView_leftDrawableWidth, 0);
        this.widths[1] = array.getDimensionPixelSize(R.styleable.DrawableTextView_topDrawableWidth, 0);
        this.widths[2] = array.getDimensionPixelSize(R.styleable.DrawableTextView_rightDrawableWidth, 0);
        this.widths[3] = array.getDimensionPixelSize(R.styleable.DrawableTextView_bottomDrawableWidth, 0);
        this.heights[0] = array.getDimensionPixelSize(R.styleable.DrawableTextView_leftDrawableHeight, 0);
        this.heights[1] = array.getDimensionPixelSize(R.styleable.DrawableTextView_topDrawableHeight, 0);
        this.heights[2] = array.getDimensionPixelSize(R.styleable.DrawableTextView_rightDrawableHeight, 0);
        this.heights[3] = array.getDimensionPixelSize(R.styleable.DrawableTextView_bottomDrawableHeight, 0);
        array.recycle();
    }

    public void setDrawable(int gravity, Drawable drawable2, int width, int height) {
        this.drawables[gravity] = drawable2;
        this.widths[gravity] = width;
        this.heights[gravity] = height;
        this.postInvalidate();
    }

    public void setDrawables(Drawable[] drawables, int[] widths, int[] heights) {
        if (drawables != null && drawables.length >= 4 && widths != null && widths.length >= 4 && heights != null && heights.length >= 4) {
            this.drawables = drawables;
            this.widths = widths;
            this.heights = heights;
            this.postInvalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        int top;
        int left;
        int drawablePadding = this.getCompoundDrawablePadding();
        this.translateText(canvas, drawablePadding);
        super.onDraw(canvas);
        float centerX = (this.getWidth() + this.getPaddingLeft() - this.getPaddingRight()) / 2;
        float centerY = (this.getHeight() + this.getPaddingTop() - this.getPaddingBottom()) / 2;
        float halfTextWidth = this.getPaint().measureText(this.getText().toString().isEmpty() ? this.getHint().toString() : this.getText().toString()) / 2.0f;
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float halfTextHeight = (fontMetrics.descent - fontMetrics.ascent) / 2.0f;
        if (this.drawables[0] != null) {
            left = (int)(centerX - (float)drawablePadding - halfTextWidth - (float)this.widths[0]);
            top = (int)(centerY - (float)(this.heights[0] / 2));
            this.drawables[0].setBounds(left, top, left + this.widths[0], top + this.heights[0]);
            canvas.save();
            this.drawables[0].draw(canvas);
            canvas.restore();
        }
        if (this.drawables[2] != null) {
            left = (int)(centerX + halfTextWidth + (float)drawablePadding);
            top = (int)(centerY - (float)(this.heights[2] / 2));
            this.drawables[2].setBounds(left, top, left + this.widths[2], top + this.heights[2]);
            canvas.save();
            this.drawables[2].draw(canvas);
            canvas.restore();
        }
        if (this.drawables[1] != null) {
            left = (int)(centerX - (float)(this.widths[1] / 2));
            int bottom = (int)(centerY - halfTextHeight - (float)drawablePadding);
            this.drawables[1].setBounds(left, bottom - this.heights[1], left + this.widths[1], bottom);
            canvas.save();
            this.drawables[1].draw(canvas);
            canvas.restore();
        }
        if (this.drawables[3] != null) {
            left = (int)(centerX - (float)(this.widths[3] / 2));
            top = (int)(centerY + halfTextHeight + (float)drawablePadding);
            this.drawables[3].setBounds(left, top, left + this.widths[3], top + this.heights[3]);
            canvas.save();
            this.drawables[3].draw(canvas);
            canvas.restore();
        }
    }

    private void translateText(Canvas canvas, int drawablePadding) {
        int translateWidth = 0;
        if (this.drawables[0] != null && this.drawables[2] != null) {
            translateWidth = (this.widths[0] - this.widths[2]) / 2;
        } else if (this.drawables[0] != null) {
            translateWidth = (this.widths[0] + drawablePadding) / 2;
        } else if (this.drawables[2] != null) {
            translateWidth = -(this.widths[2] + drawablePadding) / 2;
        }
        int translateHeight = 0;
        if (this.drawables[1] != null && this.drawables[3] != null) {
            translateHeight = (this.heights[1] - this.heights[3]) / 2;
        } else if (this.drawables[1] != null) {
            translateHeight = (this.heights[1] + drawablePadding) / 2;
        } else if (this.drawables[3] != null) {
            translateHeight = -(this.heights[3] - drawablePadding) / 2;
        }
        canvas.translate((float)translateWidth, (float)translateHeight);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrawGravity {
    }
}

