/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.example.uiwidget.R;

public class ExpandableTextView1
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = ExpandableTextView1.class.getSimpleName();
    private static final int EXPAND_INDICATOR_IMAGE_BUTTON = 0;
    private static final int EXPAND_INDICATOR_TEXT_VIEW = 1;
    private static final int DEFAULT_TOGGLE_TYPE = 0;
    private static final int MAX_COLLAPSED_LINES = 8;
    private static final int DEFAULT_ANIM_DURATION = 300;
    private static final float DEFAULT_ANIM_ALPHA_START = 0.7f;
    protected TextView mTv;
    protected View mToggleView;
    private boolean mRelayout;
    private boolean mCollapsed = true;
    private int mCollapsedHeight;
    private int mTextHeightWithMaxLines;
    private int mMaxCollapsedLines;
    private int mMarginBetweenTxtAndBottom;
    private ExpandIndicatorController mExpandIndicatorController;
    private int mAnimationDuration;
    private float mAnimAlphaStart;
    private boolean mAnimating;
    private boolean mExpandToggleOnTextClick;
    private OnExpandStateChangeListener mListener;
    private SparseBooleanArray mCollapsedStatus;
    private int mPosition;

    public ExpandableTextView1(Context context) {
        this(context, null);
    }

    public ExpandableTextView1(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    @TargetApi(value=11)
    public ExpandableTextView1(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public void setOrientation(int orientation) {
        if (0 == orientation) {
            throw new IllegalArgumentException("ExpandableTextView only supports Vertical Orientation.");
        }
        super.setOrientation(orientation);
    }

    public void onClick(View view) {
        if (this.mToggleView.getVisibility() != 0) {
            return;
        }
        this.mCollapsed = !this.mCollapsed;
        this.mExpandIndicatorController.changeState(this.mCollapsed);
        if (this.mCollapsedStatus != null) {
            this.mCollapsedStatus.put(this.mPosition, this.mCollapsed);
        }
        this.mAnimating = true;
        ExpandCollapseAnimation animation = this.mCollapsed ? new ExpandCollapseAnimation((View)this, this.getHeight(), this.mCollapsedHeight) : new ExpandCollapseAnimation((View)this, this.getHeight(), this.getHeight() + this.mTextHeightWithMaxLines - this.mTv.getHeight());
        animation.setFillAfter(true);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ExpandableTextView1.applyAlphaAnimation((View)ExpandableTextView1.this.mTv, ExpandableTextView1.this.mAnimAlphaStart);
            }

            public void onAnimationEnd(Animation animation) {
                ExpandableTextView1.this.clearAnimation();
                ExpandableTextView1.this.mAnimating = false;
                if (ExpandableTextView1.this.mListener != null) {
                    ExpandableTextView1.this.mListener.onExpandStateChanged(ExpandableTextView1.this.mTv, !ExpandableTextView1.this.mCollapsed);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.clearAnimation();
        this.startAnimation(animation);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mAnimating;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.findViews();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mRelayout || this.getVisibility() == 8) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        this.mRelayout = false;
        this.mToggleView.setVisibility(8);
        this.mTv.setMaxLines(Integer.MAX_VALUE);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTv.getLineCount() <= this.mMaxCollapsedLines) {
            return;
        }
        this.mTextHeightWithMaxLines = ExpandableTextView1.getRealTextViewHeight(this.mTv);
        if (this.mCollapsed) {
            this.mTv.setMaxLines(this.mMaxCollapsedLines);
        }
        this.mToggleView.setVisibility(0);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mCollapsed) {
            this.mTv.post(new Runnable(){

                @Override
                public void run() {
                    ExpandableTextView1.this.mMarginBetweenTxtAndBottom = ExpandableTextView1.this.getHeight() - ExpandableTextView1.this.mTv.getHeight();
                }
            });
            this.mCollapsedHeight = this.getMeasuredHeight();
        }
    }

    public void setOnExpandStateChangeListener(@Nullable OnExpandStateChangeListener listener) {
        this.mListener = listener;
    }

    public void setText(@Nullable CharSequence text) {
        this.mRelayout = true;
        this.mTv.setText(text);
        this.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
        this.clearAnimation();
        this.getLayoutParams().height = -2;
        this.requestLayout();
    }

    public void setText(@Nullable CharSequence text, @NonNull SparseBooleanArray collapsedStatus, int position) {
        this.mCollapsedStatus = collapsedStatus;
        this.mPosition = position;
        boolean isCollapsed = collapsedStatus.get(position, true);
        this.clearAnimation();
        this.mCollapsed = isCollapsed;
        this.mExpandIndicatorController.changeState(this.mCollapsed);
        this.setText(text);
    }

    @Nullable
    public CharSequence getText() {
        if (this.mTv == null) {
            return "";
        }
        return this.mTv.getText();
    }

    private void init(AttributeSet attrs) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_expandable_textview, (ViewGroup)this, true);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableTextView1);
        this.mMaxCollapsedLines = typedArray.getInt(R.styleable.ExpandableTextView1_maxCollapsedLines, 8);
        this.mAnimationDuration = typedArray.getInt(R.styleable.ExpandableTextView1_animDuration, 300);
        this.mAnimAlphaStart = typedArray.getFloat(R.styleable.ExpandableTextView1_animAlphaStart, 0.7f);
        this.mExpandToggleOnTextClick = typedArray.getBoolean(R.styleable.ExpandableTextView1_expandToggleOnTextClick, true);
        this.mExpandIndicatorController = ExpandableTextView1.setupExpandToggleController(this.getContext(), typedArray);
        typedArray.recycle();
        this.setOrientation(1);
        this.setVisibility(8);
    }

    private void findViews() {
        this.mTv = (TextView)this.findViewById(R.id.expandable_text);
        if (this.mExpandToggleOnTextClick) {
            this.mTv.setOnClickListener((View.OnClickListener)this);
        } else {
            this.mTv.setOnClickListener(null);
        }
        this.mToggleView = this.findViewById(R.id.expand_collapse);
        this.mExpandIndicatorController.setView(this.mToggleView);
        this.mExpandIndicatorController.changeState(this.mCollapsed);
        this.mToggleView.setOnClickListener((View.OnClickListener)this);
    }

    private static boolean isPostHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private static boolean isPostLolipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @TargetApi(value=11)
    private static void applyAlphaAnimation(View view, float alpha) {
        if (ExpandableTextView1.isPostHoneycomb()) {
            view.setAlpha(alpha);
        } else {
            AlphaAnimation alphaAnimation = new AlphaAnimation(alpha, alpha);
            alphaAnimation.setDuration(0L);
            alphaAnimation.setFillAfter(true);
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    @TargetApi(value=21)
    private static Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        Resources resources = context.getResources();
        if (ExpandableTextView1.isPostLolipop()) {
            return resources.getDrawable(resId, context.getTheme());
        }
        return resources.getDrawable(resId);
    }

    private static int getRealTextViewHeight(@NonNull TextView textView) {
        int textHeight = textView.getLayout().getLineTop(textView.getLineCount());
        int padding = textView.getCompoundPaddingTop() + textView.getCompoundPaddingBottom();
        return textHeight + padding;
    }

    private static ExpandIndicatorController setupExpandToggleController(@NonNull Context context, TypedArray typedArray) {
        ExpandIndicatorController expandIndicatorController;
        int expandToggleType = typedArray.getInt(R.styleable.ExpandableTextView1_expandToggleType, 0);
        switch (expandToggleType) {
            case 0: {
                Drawable expandDrawable = typedArray.getDrawable(R.styleable.ExpandableTextView1_expandIndicator);
                Drawable collapseDrawable = typedArray.getDrawable(R.styleable.ExpandableTextView1_collapseIndicator);
                if (expandDrawable == null) {
                    expandDrawable = ExpandableTextView1.getDrawable(context, R.drawable.ic_arrow_up);
                }
                if (collapseDrawable == null) {
                    collapseDrawable = ExpandableTextView1.getDrawable(context, R.drawable.ic_arrow_down);
                }
                expandIndicatorController = new ImageButtonExpandController(expandDrawable, collapseDrawable);
                break;
            }
            case 1: {
                String expandText = typedArray.getString(R.styleable.ExpandableTextView1_expandIndicator);
                String collapseText = typedArray.getString(R.styleable.ExpandableTextView1_collapseIndicator);
                expandIndicatorController = new TextViewExpandController(expandText, collapseText);
                break;
            }
            default: {
                throw new IllegalStateException("Must be of enum: ExpandableTextView_expandToggleType, one of EXPAND_INDICATOR_IMAGE_BUTTON or EXPAND_INDICATOR_TEXT_VIEW.");
            }
        }
        return expandIndicatorController;
    }

    static class TextViewExpandController
    implements ExpandIndicatorController {
        private final String mExpandText;
        private final String mCollapseText;
        private TextView mTextView;

        public TextViewExpandController(String expandText, String collapseText) {
            this.mExpandText = expandText;
            this.mCollapseText = collapseText;
        }

        @Override
        public void changeState(boolean collapsed) {
            this.mTextView.setText((CharSequence)(collapsed ? this.mExpandText : this.mCollapseText));
        }

        @Override
        public void setView(View toggleView) {
            this.mTextView = (TextView)toggleView;
        }
    }

    static class ImageButtonExpandController
    implements ExpandIndicatorController {
        private final Drawable mExpandDrawable;
        private final Drawable mCollapseDrawable;
        private ImageButton mImageButton;

        public ImageButtonExpandController(Drawable expandDrawable, Drawable collapseDrawable) {
            this.mExpandDrawable = expandDrawable;
            this.mCollapseDrawable = collapseDrawable;
        }

        @Override
        public void changeState(boolean collapsed) {
            this.mImageButton.setImageDrawable(collapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        }

        @Override
        public void setView(View toggleView) {
            this.mImageButton = (ImageButton)toggleView;
        }
    }

    static interface ExpandIndicatorController {
        public void changeState(boolean var1);

        public void setView(View var1);
    }

    public static interface OnExpandStateChangeListener {
        public void onExpandStateChanged(TextView var1, boolean var2);
    }

    class ExpandCollapseAnimation
    extends Animation {
        private final View mTargetView;
        private final int mStartHeight;
        private final int mEndHeight;

        public ExpandCollapseAnimation(View view, int startHeight, int endHeight) {
            this.mTargetView = view;
            this.mStartHeight = startHeight;
            this.mEndHeight = endHeight;
            this.setDuration(ExpandableTextView1.this.mAnimationDuration);
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int newHeight = (int)((float)(this.mEndHeight - this.mStartHeight) * interpolatedTime + (float)this.mStartHeight);
            ExpandableTextView1.this.mTv.setMaxHeight(newHeight - ExpandableTextView1.this.mMarginBetweenTxtAndBottom);
            if (Float.compare(ExpandableTextView1.this.mAnimAlphaStart, 1.0f) != 0) {
                ExpandableTextView1.applyAlphaAnimation((View)ExpandableTextView1.this.mTv, ExpandableTextView1.this.mAnimAlphaStart + interpolatedTime * (1.0f - ExpandableTextView1.this.mAnimAlphaStart));
            }
            this.mTargetView.getLayoutParams().height = newHeight;
            this.mTargetView.requestLayout();
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
        }

        public boolean willChangeBounds() {
            return true;
        }
    }
}

