/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import androidx.annotation.FloatRange;
import com.lyy.keepassa.widget.PxUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00192\b\b\u0001\u0010'\u001a\u00020\rH\u0002J\b\u0010(\u001a\u00020\nH\u0002J\b\u0010)\u001a\u00020\rH\u0002J\b\u0010*\u001a\u00020\rH\u0002J\b\u0010+\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020%H\u0002J\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020%2\u0006\u0010&\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020%2\u0006\u0010&\u001a\u000200H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u0010&\u001a\u000200H\u0016J\u0010\u00103\u001a\u00020%2\u0006\u0010&\u001a\u000200H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019H\u0016J\u0010\u00105\u001a\u00020%2\u0006\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u00020%H\u0014J\u0010\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020\u0019H\u0002J\u0010\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020\u000fH\u0002J\u0010\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020?H\u0002J\u000e\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0017J\u0006\u0010B\u001a\u00020%J\u0006\u0010C\u001a\u00020%R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/lyy/keepassa/widget/PacManView;", "Landroid/view/View;", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "Landroid/animation/Animator$AnimatorListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "ANIMATION_DURATION", "", "ANIMATION_START_DELAY", "DEFAULT_SIZE", "", "FINAL_STATE", "", "HorizontalAngle", "MAX_MOUTH_ANGLE", "mAllSize", "mCurrAnimatorState", "mDefaultStartMoveX", "mDurationTime", "mDurationTimePercent", "", "mFloatValueAnimator", "Landroid/animation/ValueAnimator;", "mFullPaint", "Landroid/graphics/Paint;", "mLastMoveDistance", "mMaxMoveRange", "mMouthAngle", "mMoveDistance", "mOuterCircleRectF", "Landroid/graphics/RectF;", "mViewHeight", "mViewWidth", "computeUpdateValue", "", "animation", "animatedValue", "getAnimationDuration", "getViewCenterX", "getViewCenterY", "initAnimators", "initPaint", "isRunning", "", "onAnimationCancel", "Landroid/animation/Animator;", "onAnimationEnd", "onAnimationRepeat", "onAnimationStart", "onAnimationUpdate", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onFinishInflate", "prepareStart", "floatValueAnimator", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setDurationTimePercent", "durationTimePercent", "start", "stop", "UIWidget_debug"})
public class PacManView
extends View
implements ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    private float DEFAULT_SIZE;
    private final long ANIMATION_START_DELAY;
    private final long ANIMATION_DURATION;
    private float mAllSize;
    private float mViewWidth;
    private float mViewHeight;
    private ValueAnimator mFloatValueAnimator;
    private double mDurationTimePercent;
    private final int FINAL_STATE;
    private final int MAX_MOUTH_ANGLE;
    private long mDurationTime;
    private Paint mFullPaint;
    private RectF mOuterCircleRectF;
    private int mMouthAngle;
    private float mMoveDistance;
    private int mCurrAnimatorState;
    private int HorizontalAngle;
    private float mMaxMoveRange;
    private float mLastMoveDistance;
    private float mDefaultStartMoveX;

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initAnimators();
        float outR = this.mAllSize;
        float inR = outR * 0.7f;
        this.mMaxMoveRange = this.mViewWidth + (float)2 * inR;
        this.initPaint();
        this.mMouthAngle = this.MAX_MOUTH_ANGLE;
        this.HorizontalAngle = 0;
        this.mDefaultStartMoveX = -this.mMaxMoveRange * 0.5f;
        this.mMoveDistance = 0.0f;
        this.mOuterCircleRectF = new RectF(this.getViewCenterX() - inR, this.getViewCenterY() - inR, this.getViewCenterX() + inR, this.getViewCenterY() + inR);
    }

    private final void initAnimators() {
        this.mAllSize = PxUtilKt.toPx(this.DEFAULT_SIZE * 0.5f - (float)12);
        this.mViewWidth = PxUtilKt.toPx(this.DEFAULT_SIZE);
        this.mViewHeight = PxUtilKt.toPx(this.DEFAULT_SIZE);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0.0f, 1.0f)");
        ValueAnimator valueAnimator2 = this.mFloatValueAnimator = valueAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator2.setRepeatCount(-1);
        ValueAnimator valueAnimator3 = this.mFloatValueAnimator;
        if (valueAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator3.setDuration(this.getAnimationDuration());
        ValueAnimator valueAnimator4 = this.mFloatValueAnimator;
        if (valueAnimator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator4.setStartDelay(this.ANIMATION_START_DELAY);
        ValueAnimator valueAnimator5 = this.mFloatValueAnimator;
        if (valueAnimator5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator5.setInterpolator((TimeInterpolator)new LinearInterpolator());
    }

    private final void initPaint() {
        Paint paint = this.mFullPaint = new Paint(1);
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = this.mFullPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint2.setColor(-1);
        Paint paint3 = this.mFullPaint;
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint3.setDither(true);
        Paint paint4 = this.mFullPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint4.setFilterBitmap(true);
        Paint paint5 = this.mFullPaint;
        if (paint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint5.setStrokeCap(Paint.Cap.ROUND);
        Paint paint6 = this.mFullPaint;
        if (paint6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint6.setStrokeJoin(Paint.Join.ROUND);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate(this.mDefaultStartMoveX + this.mMoveDistance, 0.0f);
        canvas.rotate((float)this.HorizontalAngle, this.getViewCenterX(), this.getViewCenterY());
        RectF rectF = this.mOuterCircleRectF;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mOuterCircleRectF");
        }
        float f = this.mMouthAngle;
        float f2 = 360 - this.mMouthAngle * 2;
        Paint paint = this.mFullPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        canvas.drawArc(rectF, f, f2, true, paint);
        canvas.restore();
    }

    private final void setAlpha(int alpha) {
        Paint paint = this.mFullPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint.setAlpha(alpha);
    }

    private final void prepareStart(ValueAnimator floatValueAnimator) {
        double d = (double)this.getAnimationDuration() * 0.3;
        boolean bl = false;
        this.mDurationTime = (long)Math.ceil(d);
        floatValueAnimator.setDuration(this.mDurationTime);
    }

    private final void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        int half = this.FINAL_STATE / 2 + 1;
        float step = this.mMaxMoveRange / (float)half;
        if (this.mCurrAnimatorState < half) {
            this.HorizontalAngle = 0;
            this.mMoveDistance = this.mLastMoveDistance + step * animatedValue;
        } else {
            this.HorizontalAngle = 180;
            this.mMoveDistance = this.mLastMoveDistance - step * animatedValue;
        }
        this.mMouthAngle = this.mCurrAnimatorState % 2 == 0 ? (int)((float)this.MAX_MOUTH_ANGLE * animatedValue) + 5 : (int)((float)this.MAX_MOUTH_ANGLE * (1.0f - animatedValue)) + 5;
    }

    public final void start() {
        ValueAnimator valueAnimator = this.mFloatValueAnimator;
        if (valueAnimator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        if (valueAnimator.isStarted()) {
            return;
        }
        ValueAnimator valueAnimator2 = this.mFloatValueAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        ValueAnimator valueAnimator3 = this.mFloatValueAnimator;
        if (valueAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator3.addListener((Animator.AnimatorListener)this);
        ValueAnimator valueAnimator4 = this.mFloatValueAnimator;
        if (valueAnimator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator4.setRepeatCount(-1);
        ValueAnimator valueAnimator5 = this.mFloatValueAnimator;
        if (valueAnimator5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator5.setDuration(this.getAnimationDuration());
        ValueAnimator valueAnimator6 = this.mFloatValueAnimator;
        if (valueAnimator6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        this.prepareStart(valueAnimator6);
        ValueAnimator valueAnimator7 = this.mFloatValueAnimator;
        if (valueAnimator7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator7.start();
    }

    public final void stop() {
        ValueAnimator valueAnimator = this.mFloatValueAnimator;
        if (valueAnimator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator.removeAllUpdateListeners();
        ValueAnimator valueAnimator2 = this.mFloatValueAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator2.removeAllListeners();
        ValueAnimator valueAnimator3 = this.mFloatValueAnimator;
        if (valueAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator3.setRepeatCount(0);
        ValueAnimator valueAnimator4 = this.mFloatValueAnimator;
        if (valueAnimator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator4.setDuration(0L);
        ValueAnimator valueAnimator5 = this.mFloatValueAnimator;
        if (valueAnimator5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        valueAnimator5.end();
    }

    public final boolean isRunning() {
        ValueAnimator valueAnimator = this.mFloatValueAnimator;
        if (valueAnimator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFloatValueAnimator");
        }
        return valueAnimator.isRunning();
    }

    public void onAnimationUpdate(@NotNull ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Object object = animation.getAnimatedValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        this.computeUpdateValue(animation, ((Float)object).floatValue());
    }

    public void onAnimationStart(@NotNull Animator animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    public void onAnimationEnd(@NotNull Animator animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    public void onAnimationCancel(@NotNull Animator animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    public void onAnimationRepeat(@NotNull Animator animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        PacManView pacManView = this;
        ++pacManView.mCurrAnimatorState;
        if (pacManView.mCurrAnimatorState > this.FINAL_STATE) {
            this.mCurrAnimatorState = 0;
        }
        int half = this.FINAL_STATE / 2 + 1;
        float stepRange = this.mMaxMoveRange / (float)half;
        this.mLastMoveDistance = this.mCurrAnimatorState < half ? stepRange * (float)this.mCurrAnimatorState : stepRange * (float)(half - this.mCurrAnimatorState % half);
    }

    private final void setColorFilter(ColorFilter colorFilter) {
        Paint paint = this.mFullPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFullPaint");
        }
        paint.setColorFilter(colorFilter);
    }

    public final void setDurationTimePercent(double durationTimePercent) {
        this.mDurationTimePercent = durationTimePercent <= 0.0 ? 1.0 : durationTimePercent;
    }

    private final long getAnimationDuration() {
        double d = (double)this.ANIMATION_DURATION * this.mDurationTimePercent;
        boolean bl = false;
        return (long)Math.ceil(d);
    }

    private final float getViewCenterX() {
        return this.mViewWidth * 0.5f;
    }

    private final float getViewCenterY() {
        return this.mViewHeight * 0.5f;
    }

    public PacManView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.DEFAULT_SIZE = 56.0f;
        this.ANIMATION_START_DELAY = 333L;
        this.ANIMATION_DURATION = 1333L;
        this.mDurationTimePercent = 1.0;
        this.FINAL_STATE = 9;
        this.MAX_MOUTH_ANGLE = 45;
        this.mDurationTime = 333L;
    }

    public /* synthetic */ PacManView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }
}

