/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.ProgressBar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.example.uiwidget.R;
import com.lyy.keepassa.widget.ProgressBar.HorizontalProgressBarWithNumber;

public class RoundProgressBarWidthNumber
extends HorizontalProgressBarWithNumber {
    private int mRadius = this.dp2px(30);
    private int mMaxPaintWidth;
    private boolean isCountdown = false;

    public RoundProgressBarWidthNumber(Context context) {
        this(context, null);
    }

    public RoundProgressBarWidthNumber(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mReachedProgressBarHeight = (int)((float)this.mUnReachedProgressBarHeight * 2.5f);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RoundProgressBarWidthNumber);
        this.mRadius = (int)ta.getDimension(R.styleable.RoundProgressBarWidthNumber_radius, (float)this.mRadius);
        this.isCountdown = ta.getBoolean(R.styleable.RoundProgressBarWidthNumber_progress_countdown, false);
        ta.recycle();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMaxPaintWidth = Math.max(this.mReachedProgressBarHeight, this.mUnReachedProgressBarHeight);
        int expect = this.mRadius * 2 + this.mMaxPaintWidth + this.getPaddingLeft() + this.getPaddingRight();
        int width = RoundProgressBarWidthNumber.resolveSize((int)expect, (int)widthMeasureSpec);
        int height = RoundProgressBarWidthNumber.resolveSize((int)expect, (int)heightMeasureSpec);
        int realWidth = Math.min(width, height);
        this.mRadius = (realWidth - this.getPaddingLeft() - this.getPaddingRight() - this.mMaxPaintWidth) / 2;
        this.setMeasuredDimension(realWidth, realWidth);
    }

    public void setCountdown(boolean countdown) {
        this.isCountdown = countdown;
    }

    @Override
    @SuppressLint(value={"DrawAllocation"})
    protected synchronized void onDraw(Canvas canvas) {
        String text = this.getProgress() + (this.showPercent ? "%" : "");
        float textWidth = this.mPaint.measureText(text);
        float textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        canvas.save();
        canvas.translate((float)(this.getPaddingLeft() + (this.mMaxPaintWidth >> 1)), (float)(this.getPaddingTop() + (this.mMaxPaintWidth >> 1)));
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mUnReachedBarColor);
        this.mPaint.setStrokeWidth((float)this.mUnReachedProgressBarHeight);
        canvas.drawCircle((float)this.mRadius, (float)this.mRadius, (float)this.mRadius, this.mPaint);
        this.mPaint.setColor(this.mReachedBarColor);
        this.mPaint.setStrokeWidth((float)this.mReachedProgressBarHeight);
        float sweepAngle = !this.isCountdown ? (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f : 360.0f - (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        canvas.drawArc(new RectF(0.0f, 0.0f, (float)(this.mRadius << 1), (float)(this.mRadius << 1)), 0.0f, sweepAngle, false, this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(text, (float)this.mRadius - textWidth / 2.0f, (float)this.mRadius - textHeight, this.mPaint);
        canvas.restore();
    }
}

