/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.discreteSeekBar.internal.compat;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.graphics.drawable.DrawableCompat;
import com.lyy.keepassa.widget.discreteSeekBar.internal.compat.SeekBarCompatDontCrash;
import com.lyy.keepassa.widget.discreteSeekBar.internal.drawable.AlmostRippleDrawable;
import com.lyy.keepassa.widget.discreteSeekBar.internal.drawable.MarkerDrawable;

public class SeekBarCompat {
    public static void setOutlineProvider(View view, MarkerDrawable markerDrawable) {
        if (Build.VERSION.SDK_INT >= 21) {
            SeekBarCompatDontCrash.setOutlineProvider(view, markerDrawable);
        }
    }

    public static Drawable getRipple(ColorStateList colorStateList) {
        if (Build.VERSION.SDK_INT >= 21) {
            return SeekBarCompatDontCrash.getRipple(colorStateList);
        }
        return new AlmostRippleDrawable(colorStateList);
    }

    public static void setRippleColor(@NonNull Drawable drawable2, ColorStateList colorStateList) {
        if (Build.VERSION.SDK_INT >= 21) {
            ((RippleDrawable)drawable2).setColor(colorStateList);
        } else {
            ((AlmostRippleDrawable)drawable2).setColor(colorStateList);
        }
    }

    public static void setHotspotBounds(Drawable drawable2, int left, int top, int right, int bottom) {
        if (Build.VERSION.SDK_INT >= 21) {
            int size = (right - left) / 8;
            DrawableCompat.setHotspotBounds((Drawable)drawable2, (int)(left + size), (int)(top + size), (int)(right - size), (int)(bottom - size));
        } else {
            drawable2.setBounds(left, top, right, bottom);
        }
    }

    public static void setBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            SeekBarCompatDontCrash.setBackground(view, background);
        } else {
            view.setBackgroundDrawable(background);
        }
    }

    public static void setTextDirection(TextView textView, int textDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            SeekBarCompatDontCrash.setTextDirection(textView, textDirection);
        }
    }

    public static boolean isInScrollingContainer(ViewParent p) {
        if (Build.VERSION.SDK_INT >= 14) {
            return SeekBarCompatDontCrash.isInScrollingContainer(p);
        }
        return false;
    }

    public static boolean isHardwareAccelerated(View view) {
        if (Build.VERSION.SDK_INT >= 11) {
            return SeekBarCompatDontCrash.isHardwareAccelerated(view);
        }
        return false;
    }
}

