/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.discreteSeekBar.internal.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.lyy.keepassa.widget.discreteSeekBar.internal.drawable.StateDrawable;

public class ThumbDrawable
extends StateDrawable
implements Animatable {
    public static final int DEFAULT_SIZE_DP = 12;
    private final int mSize;
    private boolean mOpen;
    private boolean mRunning;
    private Runnable opener = new Runnable(){

        @Override
        public void run() {
            ThumbDrawable.this.mOpen = true;
            ThumbDrawable.this.invalidateSelf();
            ThumbDrawable.this.mRunning = false;
        }
    };

    public ThumbDrawable(@NonNull ColorStateList tintStateList, int size) {
        super(tintStateList);
        this.mSize = size;
    }

    public int getIntrinsicWidth() {
        return this.mSize;
    }

    public int getIntrinsicHeight() {
        return this.mSize;
    }

    @Override
    public void doDraw(Canvas canvas, Paint paint) {
        if (!this.mOpen) {
            Rect bounds = this.getBounds();
            float radius = this.mSize / 2;
            canvas.drawCircle((float)bounds.centerX(), (float)bounds.centerY(), radius, paint);
        }
    }

    public void animateToPressed() {
        this.scheduleSelf(this.opener, SystemClock.uptimeMillis() + 100L);
        this.mRunning = true;
    }

    public void animateToNormal() {
        this.mOpen = false;
        this.mRunning = false;
        this.unscheduleSelf(this.opener);
        this.invalidateSelf();
    }

    public void start() {
    }

    public void stop() {
        this.animateToNormal();
    }

    public boolean isRunning() {
        return this.mRunning;
    }
}

