/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.editor;

import com.lyy.keepassa.widget.editor.IAction;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/lyy/keepassa/widget/editor/ActionManager;", "", "()V", "capacity", "", "redoQueue", "Ljava/util/ArrayDeque;", "Lcom/lyy/keepassa/widget/editor/IAction;", "undoQueue", "canRedo", "", "canUndo", "getRedoQueue", "getUndoQueue", "redo", "setLastAction", "", "action", "undo", "UIWidget_debug"})
public final class ActionManager {
    private final int capacity;
    private final ArrayDeque<IAction> redoQueue = new ArrayDeque();
    private final ArrayDeque<IAction> undoQueue = new ArrayDeque();

    @NotNull
    public final ArrayDeque<IAction> getRedoQueue() {
        return this.redoQueue;
    }

    @NotNull
    public final ArrayDeque<IAction> getUndoQueue() {
        return this.undoQueue;
    }

    public final void setLastAction(@NotNull IAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.redoQueue.clear();
        this.undoQueue.add(action);
    }

    public final boolean canUndo() {
        return this.undoQueue.size() > 0;
    }

    public final boolean canRedo() {
        return this.redoQueue.size() > 0;
    }

    @Nullable
    public final IAction undo() {
        if (this.redoQueue.size() >= this.capacity) {
            this.redoQueue.pollFirst();
        }
        IAction undoAction = this.undoQueue.pollLast();
        this.redoQueue.offer(undoAction);
        return undoAction;
    }

    @Nullable
    public final IAction redo() {
        if (this.undoQueue.size() >= this.capacity) {
            this.undoQueue.pollFirst();
        }
        IAction redoAction = this.redoQueue.pollLast();
        this.undoQueue.offer(redoAction);
        return redoAction;
    }

    public ActionManager() {
        this.capacity = 100;
    }
}

