/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.editor;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import androidx.appcompat.widget.AppCompatEditText;
import com.lyy.keepassa.widget.editor.OperateManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0006\u0010#\u001a\u00020\u001dJ\b\u0010$\u001a\u00020\u001dH\u0014J\b\u0010%\u001a\u00020\u001dH\u0014J\b\u0010&\u001a\u00020\u001dH\u0014J*\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 H\u0014J\u0006\u0010,\u001a\u00020\u001dJ\u0006\u0010-\u001a\u00020\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/lyy/keepassa/widget/editor/EditorView;", "Landroidx/appcompat/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "INTERVAL", "", "TAG", "", "kotlin.jvm.PlatformType", "cache", "Lcom/lyy/keepassa/widget/editor/EditorView$CharBuffer;", "getCache", "()Lcom/lyy/keepassa/widget/editor/EditorView$CharBuffer;", "cache$delegate", "Lkotlin/Lazy;", "isOperating", "", "lastOperateTime", "operateManager", "Lcom/lyy/keepassa/widget/editor/OperateManager;", "getOperateManager", "()Lcom/lyy/keepassa/widget/editor/OperateManager;", "operateManager$delegate", "scope", "Lkotlinx/coroutines/CoroutineScope;", "addNewStr", "", "s", "start", "", "addOperateStr", "checkCache", "clear", "onAttachedToWindow", "onDetachedFromWindow", "onFinishInflate", "onTextChanged", "text", "", "lengthBefore", "lengthAfter", "redo", "undo", "CharBuffer", "UIWidget_debug"})
public final class EditorView
extends AppCompatEditText {
    private final String TAG;
    private CoroutineScope scope;
    private final long INTERVAL;
    private long lastOperateTime;
    private boolean isOperating;
    private final Lazy operateManager$delegate;
    private final Lazy cache$delegate;

    private final OperateManager getOperateManager() {
        Lazy lazy = this.operateManager$delegate;
        EditorView editorView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OperateManager)lazy.getValue();
    }

    private final CharBuffer getCache() {
        Lazy lazy = this.cache$delegate;
        EditorView editorView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CharBuffer)lazy.getValue();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setInputType(655360);
        this.setSingleLine(false);
        this.addTextChangedListener(new TextWatcher(this){
            @NotNull
            private String beforeStr;
            final /* synthetic */ EditorView this$0;

            @NotNull
            public final String getBeforeStr() {
                return this.beforeStr;
            }

            public final void setBeforeStr(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.beforeStr = string;
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                block0: {
                    CharSequence charSequence = s;
                    if (charSequence == null) break block0;
                    CharSequence charSequence2 = charSequence;
                    boolean bl = false;
                    boolean bl2 = false;
                    CharSequence it = charSequence2;
                    boolean bl3 = false;
                    this.beforeStr = ((Object)it).toString();
                }
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                CharSequence delStr;
                int n;
                Log.d((String)EditorView.access$getTAG$p(this.this$0), (String)("onTextChanged: s = " + s + ", start = " + start + ", before = " + before + ", count = " + count));
                if (EditorView.access$isOperating$p(this.this$0)) {
                    Log.w((String)EditorView.access$getTAG$p(this.this$0), (String)"isOperating");
                    return;
                }
                if (count == 0) {
                    String string;
                    CharSequence charSequence = s;
                    n = 0;
                    int n2 = 0;
                    if (charSequence == null || charSequence.length() == 0) {
                        string = this.beforeStr;
                    } else {
                        charSequence = this.beforeStr;
                        n = start - before + 1;
                        n2 = start + 1;
                        boolean bl = false;
                        CharSequence charSequence2 = charSequence;
                        if (charSequence2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = ((String)charSequence2).substring(n, n2);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    }
                    delStr = string;
                    Log.d((String)EditorView.access$getTAG$p(this.this$0), (String)("beforeStr = " + this.beforeStr + ", delete Str = " + (String)delStr));
                    EditorView.access$getOperateManager$p(this.this$0).delete((String)delStr, start - before, start);
                }
                delStr = s;
                boolean bl = false;
                n = 0;
                if (delStr == null || delStr.length() == 0) {
                    return;
                }
                if (before == 0 && count != 0) {
                    CharSequence newStr = s.subSequence(start, start + count);
                    EditorView.access$addNewStr(this.this$0, ((Object)newStr).toString(), start);
                    return;
                }
            }

            public void afterTextChanged(@Nullable Editable s) {
            }
            {
                this.this$0 = this$0;
                this.beforeStr = "";
            }
        });
    }

    protected void onTextChanged(@Nullable CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.isOperating = false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!CoroutineScopeKt.isActive((CoroutineScope)this.scope)) {
            this.scope = CoroutineScopeKt.MainScope();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getOperateManager().destroy();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    private final void addNewStr(String s, int start) {
        this.lastOperateTime = System.currentTimeMillis();
        this.getOperateManager().add(s, start);
    }

    public final void addOperateStr(@NotNull String s, int start) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.getOperateManager().add(s, start);
    }

    public final void undo() {
        this.checkCache();
        this.isOperating = true;
        this.getOperateManager().undo();
        this.isOperating = false;
    }

    public final void redo() {
        this.checkCache();
        this.isOperating = true;
        this.getOperateManager().redo();
        this.isOperating = false;
    }

    public final void clear() {
        this.checkCache();
        this.isOperating = true;
        String newStr = this.getOperateManager().clear();
        this.setText(newStr);
        this.setSelection(newStr.length());
    }

    private final void checkCache() {
        if (this.getCache().isEmpty()) {
            return;
        }
        Pair<Integer, CharSequence> p = this.getCache().getCache();
        this.addNewStr(p.getSecond().toString(), ((Number)p.getFirst()).intValue());
    }

    public EditorView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.TAG = ((Object)((Object)this)).getClass().getSimpleName();
        this.scope = CoroutineScopeKt.MainScope();
        this.INTERVAL = 1000L;
        this.lastOperateTime = System.currentTimeMillis();
        this.operateManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OperateManager>(this){
            final /* synthetic */ EditorView this$0;

            @NotNull
            public final OperateManager invoke() {
                Editable editable = this.this$0.getEditableText();
                Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"this.editableText");
                return new OperateManager(editable);
            }
            {
                this.this$0 = editorView;
                super(0);
            }
        }));
        this.cache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CharBuffer>(this){
            final /* synthetic */ EditorView this$0;

            @NotNull
            public final CharBuffer invoke() {
                Editable editable = this.this$0.getEditableText();
                Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"this.editableText");
                return new CharBuffer(editable);
            }
            {
                this.this$0 = editorView;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$getTAG$p(EditorView $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ boolean access$isOperating$p(EditorView $this) {
        return $this.isOperating;
    }

    public static final /* synthetic */ void access$setOperating$p(EditorView $this, boolean bl) {
        $this.isOperating = bl;
    }

    public static final /* synthetic */ OperateManager access$getOperateManager$p(EditorView $this) {
        return $this.getOperateManager();
    }

    public static final /* synthetic */ void access$addNewStr(EditorView $this, String s, int start) {
        $this.addNewStr(s, start);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/lyy/keepassa/widget/editor/EditorView$CharBuffer;", "", "ed", "Landroid/text/Editable;", "(Landroid/text/Editable;)V", "getEd", "()Landroid/text/Editable;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "start", "", "addChart", "", "charSequence", "", "getCache", "Lkotlin/Pair;", "isEmpty", "", "UIWidget_debug"})
    private static final class CharBuffer {
        private StringBuilder sb;
        private int start;
        @NotNull
        private final Editable ed;

        private final void addChart(int start, CharSequence charSequence) {
            this.start = start;
            this.sb.append(charSequence);
        }

        public final boolean isEmpty() {
            CharSequence charSequence = this.sb;
            boolean bl = false;
            return charSequence.length() == 0;
        }

        @NotNull
        public final Pair<Integer, CharSequence> getCache() {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            String str = string;
            Pair p = new Pair((Object)this.start, (Object)str);
            this.start = this.ed.length();
            StringsKt.clear((StringBuilder)this.sb);
            return p;
        }

        @NotNull
        public final Editable getEd() {
            return this.ed;
        }

        public CharBuffer(@NotNull Editable ed) {
            Intrinsics.checkNotNullParameter((Object)ed, (String)"ed");
            this.ed = ed;
            this.sb = new StringBuilder();
            this.start = this.ed.length();
        }
    }
}

