/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatTextView;
import com.example.uiwidget.R;
import com.lyy.keepassa.widget.PxUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0016\u001a\u00020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\tR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/lyy/keepassa/widget/BubbleTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "iconClickListener", "Lcom/lyy/keepassa/widget/BubbleTextView$OnIconClickListener;", "iconSize", "", "clearIcon", "", "location", "contentRect", "Landroid/graphics/Rect;", "isTouchIcon", "event", "Landroid/view/MotionEvent;", "onTouchEvent", "", "setEndIcon", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableId", "setLeftIcon", "setOnIconClickListener", "listener", "Companion", "OnIconClickListener", "UIWidget_debug"})
public final class BubbleTextView
extends AppCompatTextView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int iconSize;
    @Nullable
    private OnIconClickListener iconClickListener;
    private static final int LOCATION_LEFT;
    private static final int LOCATION_TOP;
    private static final int LOCATION_RIGHT;
    private static final int LOCATION_BOTTOM;

    public BubbleTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BubbleTextView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026styleable.BubbleTextView)");
        TypedArray ta = typedArray;
        float iconSize = ta.getDimension(R.styleable.BubbleTextView_icon_size, (float)PxUtilKt.toPx(24));
        Drawable leftIcon = ta.getDrawable(R.styleable.BubbleTextView_left_icon);
        Drawable topIcon = ta.getDrawable(R.styleable.BubbleTextView_top_icon);
        Drawable rightIcon = ta.getDrawable(R.styleable.BubbleTextView_right_icon);
        Drawable bottomIcon = ta.getDrawable(R.styleable.BubbleTextView_bottom_icon);
        if (leftIcon != null) {
            leftIcon.setBounds(new Rect(0, 0, (int)iconSize, (int)iconSize));
        }
        if (topIcon != null) {
            topIcon.setBounds(new Rect(0, 0, (int)iconSize, (int)iconSize));
        }
        if (rightIcon != null) {
            rightIcon.setBounds(new Rect(0, 0, (int)iconSize, (int)iconSize));
        }
        if (bottomIcon != null) {
            bottomIcon.setBounds(new Rect(0, 0, (int)iconSize, (int)iconSize));
        }
        this.setCompoundDrawables(leftIcon, topIcon, rightIcon, bottomIcon);
        this.iconSize = (int)iconSize;
        ta.recycle();
        this.setClickable(true);
    }

    public BubbleTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public final void clearIcon(int location) {
        int n = location;
        if (n == LOCATION_LEFT) {
            this.setCompoundDrawables(null, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
        } else if (n == LOCATION_TOP) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], null, this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
        } else if (n == LOCATION_RIGHT) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], null, this.getCompoundDrawables()[3]);
        } else if (n == LOCATION_BOTTOM) {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], null);
        }
    }

    public final void setLeftIcon(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        drawable2.setBounds(new Rect(0, 0, this.iconSize, this.iconSize));
        this.setCompoundDrawables(drawable2, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
    }

    public final void setLeftIcon(@DrawableRes int drawableId) {
        Drawable drawable2 = this.getResources().getDrawable(drawableId, this.getContext().getTheme());
        drawable2.setBounds(new Rect(0, 0, this.iconSize, this.iconSize));
        this.setCompoundDrawables(drawable2, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
    }

    public final void setEndIcon(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        drawable2.setBounds(new Rect(0, 0, this.iconSize, this.iconSize));
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], drawable2, this.getCompoundDrawables()[3]);
    }

    public final void setEndIcon(@DrawableRes int drawableId) {
        Drawable drawable2 = this.getResources().getDrawable(drawableId, this.getContext().getTheme());
        drawable2.setBounds(new Rect(0, 0, this.iconSize, this.iconSize));
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], drawable2, this.getCompoundDrawables()[3]);
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        MotionEvent motionEvent = event;
        Intrinsics.checkNotNull((Object)motionEvent);
        int clickIconIndex = this.isTouchIcon(motionEvent);
        if (clickIconIndex == -1) {
            return super.onTouchEvent(event);
        }
        if (this.iconClickListener != null) {
            OnIconClickListener onIconClickListener = this.iconClickListener;
            Intrinsics.checkNotNull((Object)onIconClickListener);
            onIconClickListener.onClick(this, clickIconIndex);
        }
        return true;
    }

    public final void setOnIconClickListener(@NotNull OnIconClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.iconClickListener = listener;
    }

    private final int isTouchIcon(MotionEvent event) {
        Object[] objectArray = this.getCompoundDrawables();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"compoundDrawables");
        objectArray = objectArray;
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        if (!(objectArray2.length == 0) && event.getAction() == 0) {
            Rect contentRect = this.contentRect();
            n = 0;
            do {
                RectF temp;
                int index = n++;
                Drawable icon = this.getCompoundDrawables()[index];
                this.getCompoundDrawables();
                if (icon == null) continue;
                int l = 0;
                int t = 0;
                int r = 0;
                int b = 0;
                if (index == 0) {
                    l = 0;
                    t = contentRect.top;
                }
                if (index == 1) {
                    l = (this.getCompoundPaddingLeft() + contentRect.right - icon.getBounds().width()) / 2;
                    t = 0;
                }
                if (index == 2) {
                    l = contentRect.right;
                    t = contentRect.top;
                }
                if (index == 3) {
                    l = (this.getCompoundPaddingLeft() + contentRect.right - icon.getBounds().width()) / 2;
                    t = contentRect.bottom;
                }
                if (!(temp = new RectF((float)l, (float)t, (float)(r = l + icon.getBounds().width()), (float)(b = t + icon.getBounds().height()))).contains(event.getX(), event.getY())) continue;
                return index;
            } while (n <= 3);
        }
        return -1;
    }

    private final Rect contentRect() {
        return new Rect(this.getCompoundPaddingLeft(), this.getCompoundPaddingTop(), this.getWidth() - this.getCompoundPaddingRight(), this.getHeight() - this.getCompoundPaddingBottom());
    }

    static {
        LOCATION_TOP = 1;
        LOCATION_RIGHT = 2;
        LOCATION_BOTTOM = 3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/lyy/keepassa/widget/BubbleTextView$Companion;", "", "()V", "LOCATION_BOTTOM", "", "getLOCATION_BOTTOM", "()I", "LOCATION_LEFT", "getLOCATION_LEFT", "LOCATION_RIGHT", "getLOCATION_RIGHT", "LOCATION_TOP", "getLOCATION_TOP", "UIWidget_debug"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLOCATION_LEFT() {
            return LOCATION_LEFT;
        }

        public final int getLOCATION_TOP() {
            return LOCATION_TOP;
        }

        public final int getLOCATION_RIGHT() {
            return LOCATION_RIGHT;
        }

        public final int getLOCATION_BOTTOM() {
            return LOCATION_BOTTOM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/lyy/keepassa/widget/BubbleTextView$OnIconClickListener;", "", "onClick", "", "view", "Lcom/lyy/keepassa/widget/BubbleTextView;", "index", "", "UIWidget_debug"})
    public static interface OnIconClickListener {
        public void onClick(@NotNull BubbleTextView var1, int var2);
    }
}

