/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.text.Layout;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AlignmentSpan;
import android.text.style.ClickableSpan;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.example.uiwidget.R;
import com.lyy.keepassa.widget.OverLinkMovementMethod;

@Deprecated
public class ExpandAbleTextView
extends AppCompatTextView {
    private static final String TAG = ExpandAbleTextView.class.getSimpleName();
    public static final String ELLIPSIS_STRING = new String(new char[]{'\u2026'});
    private static final int STATE_EXPEND = 1;
    private static final int STATE_SHRINK = 1;
    private static final int DEFAULT_MAX_LINE = 3;
    private static final String DEFAULT_OPEN_SUFFIX = " \u5c55\u5f00";
    private static final String DEFAULT_CLOSE_SUFFIX = " \u6536\u8d77";
    volatile boolean animating = false;
    boolean isClosed = false;
    private int mMaxLines = 3;
    private int initWidth = 0;
    private CharSequence originalText;
    private SpannableStringBuilder mOpenSpannableStr;
    private SpannableStringBuilder mCloseSpannableStr;
    private boolean hasAnimation = false;
    private Animation mOpenAnim;
    private Animation mCloseAnim;
    private int mOpenHeight;
    private int mCLoseHeight;
    private boolean mExpandable;
    private boolean mCloseInNewLine;
    @Nullable
    private SpannableString mOpenSuffixSpan;
    @Nullable
    private SpannableString mCloseSuffixSpan;
    private String mOpenSuffixStr = " \u5c55\u5f00";
    private String mCloseSuffixStr = " \u6536\u8d77";
    private int mOpenSuffixColor;
    private int mCloseSuffixColor;
    private int mCurState = 1;
    private View.OnClickListener mOnClickListener;
    private CharSequenceToSpannableHandler mCharSequenceToSpannableHandler;
    private boolean needSetOriginText = false;
    private CharSequence tempOriginalText;
    public OpenAndCloseCallback mOpenCloseCallback;

    public ExpandAbleTextView(Context context) {
        super(context);
        this.initialize(context, null);
    }

    public ExpandAbleTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public ExpandAbleTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExpandAbleTextView);
            this.mOpenSuffixColor = this.mCloseSuffixColor = a.getColor(R.styleable.ExpandAbleTextView_eav_suffix_color, Color.parseColor((String)"#F23030"));
            this.mOpenSuffixStr = a.getString(R.styleable.ExpandAbleTextView_eav_suffix_expand);
            this.mCloseSuffixStr = a.getString(R.styleable.ExpandAbleTextView_eav_suffix_shirk);
            a.recycle();
        }
        if (TextUtils.isEmpty((CharSequence)this.mOpenSuffixStr)) {
            this.mOpenSuffixStr = DEFAULT_OPEN_SUFFIX;
        }
        this.mCloseSuffixStr = TextUtils.isEmpty((CharSequence)this.mCloseSuffixStr) ? DEFAULT_CLOSE_SUFFIX : " ".concat(this.mCloseSuffixStr);
        this.setMovementMethod(OverLinkMovementMethod.getInstance());
        this.setIncludeFontPadding(false);
        this.updateOpenSuffixSpan();
        this.updateCloseSuffixSpan();
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    private void setCustomText(CharSequence originalText) {
        this.originalText = originalText;
        this.mExpandable = false;
        this.mCloseSpannableStr = new SpannableStringBuilder();
        int maxLines = this.mMaxLines;
        SpannableStringBuilder tempText = this.charSequenceToSpannable(originalText);
        this.mOpenSpannableStr = this.charSequenceToSpannable(originalText);
        if (maxLines != -1) {
            Layout layout2 = this.createStaticLayout(tempText);
            boolean bl = this.mExpandable = layout2.getLineCount() > maxLines;
            if (this.mExpandable) {
                int lastSpace;
                if (this.mCloseInNewLine) {
                    this.mOpenSpannableStr.append((CharSequence)"\n");
                }
                if (this.mCloseSuffixSpan != null) {
                    this.mOpenSpannableStr.append((CharSequence)this.mCloseSuffixSpan);
                }
                int endPos = layout2.getLineEnd(maxLines - 1);
                this.mCloseSpannableStr = originalText.length() <= endPos ? this.charSequenceToSpannable(originalText) : this.charSequenceToSpannable(originalText.subSequence(0, endPos));
                SpannableStringBuilder tempText2 = this.charSequenceToSpannable((CharSequence)this.mCloseSpannableStr).append((CharSequence)ELLIPSIS_STRING);
                if (this.mOpenSuffixSpan != null) {
                    tempText2.append((CharSequence)this.mOpenSuffixSpan);
                }
                Layout tempLayout = this.createStaticLayout(tempText2);
                while (tempLayout.getLineCount() > maxLines && (lastSpace = this.mCloseSpannableStr.length() - 1) != -1) {
                    this.mCloseSpannableStr = originalText.length() <= lastSpace ? this.charSequenceToSpannable(originalText) : this.charSequenceToSpannable(originalText.subSequence(0, lastSpace));
                    tempText2 = this.charSequenceToSpannable((CharSequence)this.mCloseSpannableStr).append((CharSequence)ELLIPSIS_STRING);
                    if (this.mOpenSuffixSpan != null) {
                        tempText2.append((CharSequence)this.mOpenSuffixSpan);
                    }
                    tempLayout = this.createStaticLayout(tempText2);
                }
                lastSpace = this.mCloseSpannableStr.length() - this.mOpenSuffixSpan.length();
                if (lastSpace >= 0 && originalText.length() > lastSpace) {
                    CharSequence redundantChar = originalText.subSequence(lastSpace, lastSpace + this.mOpenSuffixSpan.length());
                    int offset = this.hasEnCharCount(redundantChar) - this.hasEnCharCount((CharSequence)this.mOpenSuffixSpan) + 1;
                    lastSpace = offset <= 0 ? lastSpace : lastSpace - offset;
                    this.mCloseSpannableStr = this.charSequenceToSpannable(originalText.subSequence(0, lastSpace));
                }
                this.mCLoseHeight = tempLayout.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
                this.mCloseSpannableStr.append((CharSequence)ELLIPSIS_STRING);
                if (this.mOpenSuffixSpan != null) {
                    this.mCloseSpannableStr.append((CharSequence)this.mOpenSuffixSpan);
                }
            }
        }
        this.isClosed = this.mExpandable;
        if (this.mExpandable) {
            this.setText((CharSequence)this.mCloseSpannableStr);
            super.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ExpandAbleTextView.this.mOnClickListener != null) {
                        ExpandAbleTextView.this.mOnClickListener.onClick(v);
                    }
                }
            });
        } else {
            this.setText((CharSequence)this.mOpenSpannableStr);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.needSetOriginText) {
            this.initWidth = this.getMeasuredWidth();
            this.setCustomText(this.tempOriginalText);
            this.needSetOriginText = false;
        }
    }

    public void setOriginalText(CharSequence originalText) {
        if (this.initWidth == 0) {
            this.needSetOriginText = true;
            this.tempOriginalText = originalText;
            return;
        }
        this.setCustomText(originalText);
    }

    private int hasEnCharCount(CharSequence str) {
        int count = 0;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c < ' ' || c > '~') continue;
                ++count;
            }
        }
        return count;
    }

    private void switchOpenClose() {
        if (this.mExpandable) {
            boolean bl = this.isClosed = !this.isClosed;
            if (this.isClosed) {
                this.close();
            } else {
                this.open();
            }
        }
    }

    public void setHasAnimation(boolean hasAnimation) {
        this.hasAnimation = hasAnimation;
    }

    private void open() {
        this.mCurState = 1;
        if (this.hasAnimation) {
            Layout layout2 = this.createStaticLayout(this.mOpenSpannableStr);
            this.mOpenHeight = layout2.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
            this.executeOpenAnim();
        } else {
            ExpandAbleTextView.super.setMaxLines(Integer.MAX_VALUE);
            this.setText((CharSequence)this.mOpenSpannableStr);
            if (this.mOpenCloseCallback != null) {
                this.mOpenCloseCallback.onOpen();
            }
        }
    }

    private void close() {
        this.mCurState = 1;
        if (this.hasAnimation) {
            this.executeCloseAnim();
        } else {
            ExpandAbleTextView.super.setMaxLines(this.mMaxLines);
            this.setText((CharSequence)this.mCloseSpannableStr);
            if (this.mOpenCloseCallback != null) {
                this.mOpenCloseCallback.onClose();
            }
        }
    }

    private void executeOpenAnim() {
        if (this.mOpenAnim == null) {
            this.mOpenAnim = new ExpandCollapseAnimation((View)this, this.mCLoseHeight, this.mOpenHeight);
            this.mOpenAnim.setFillAfter(true);
            this.mOpenAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    ExpandAbleTextView.super.setMaxLines(Integer.MAX_VALUE);
                    ExpandAbleTextView.this.setText((CharSequence)ExpandAbleTextView.this.mOpenSpannableStr);
                }

                public void onAnimationEnd(Animation animation) {
                    ExpandAbleTextView.this.getLayoutParams().height = ExpandAbleTextView.this.mOpenHeight;
                    ExpandAbleTextView.this.requestLayout();
                    ExpandAbleTextView.this.animating = false;
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.clearAnimation();
        this.startAnimation(this.mOpenAnim);
    }

    private void executeCloseAnim() {
        if (this.mCloseAnim == null) {
            this.mCloseAnim = new ExpandCollapseAnimation((View)this, this.mOpenHeight, this.mCLoseHeight);
            this.mCloseAnim.setFillAfter(true);
            this.mCloseAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ExpandAbleTextView.this.animating = false;
                    ExpandAbleTextView.super.setMaxLines(ExpandAbleTextView.this.mMaxLines);
                    ExpandAbleTextView.this.setText((CharSequence)ExpandAbleTextView.this.mCloseSpannableStr);
                    ExpandAbleTextView.this.getLayoutParams().height = ExpandAbleTextView.this.mCLoseHeight;
                    ExpandAbleTextView.this.requestLayout();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        if (this.animating) {
            return;
        }
        this.animating = true;
        this.clearAnimation();
        this.startAnimation(this.mCloseAnim);
    }

    private Layout createStaticLayout(SpannableStringBuilder spannable) {
        int contentWidth = this.initWidth - this.getPaddingLeft() - this.getPaddingRight();
        if (Build.VERSION.SDK_INT >= 23) {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)spannable, (int)0, (int)spannable.length(), (TextPaint)this.getPaint(), (int)contentWidth);
            builder.setAlignment(Layout.Alignment.ALIGN_NORMAL);
            builder.setIncludePad(this.getIncludeFontPadding());
            builder.setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier());
            return builder.build();
        }
        return new StaticLayout((CharSequence)spannable, this.getPaint(), contentWidth, Layout.Alignment.ALIGN_NORMAL, this.getLineSpacingMultiplier(), this.getLineSpacingExtra(), this.getIncludeFontPadding());
    }

    private SpannableStringBuilder charSequenceToSpannable(@NonNull CharSequence charSequence) {
        SpannableStringBuilder spannableStringBuilder = null;
        if (this.mCharSequenceToSpannableHandler != null) {
            spannableStringBuilder = this.mCharSequenceToSpannableHandler.charSequenceToSpannable(charSequence);
        }
        if (spannableStringBuilder == null) {
            spannableStringBuilder = new SpannableStringBuilder(charSequence);
        }
        return spannableStringBuilder;
    }

    public void initWidth(int width) {
        this.initWidth = width;
    }

    public void setMaxLines(int maxLines) {
        this.mMaxLines = maxLines;
        super.setMaxLines(maxLines);
    }

    public void setExpandSuffix(String openSuffix) {
        this.mOpenSuffixStr = " " + openSuffix;
        this.updateOpenSuffixSpan();
    }

    public void setExpandSuffixColor(@ColorInt int openSuffixColor) {
        this.mOpenSuffixColor = openSuffixColor;
        this.updateOpenSuffixSpan();
    }

    public void setShrinkSuffix(String closeSuffix) {
        this.mCloseSuffixStr = " " + closeSuffix;
        this.updateCloseSuffixSpan();
    }

    public void setShrinkSuffixColor(@ColorInt int closeSuffixColor) {
        this.mCloseSuffixColor = closeSuffixColor;
        this.updateCloseSuffixSpan();
    }

    public void setShrinkInNewLine(boolean closeInNewLine) {
        this.mCloseInNewLine = closeInNewLine;
        this.updateCloseSuffixSpan();
    }

    @Deprecated
    public CharSequence getText() {
        return super.getText();
    }

    public CharSequence getOriginalText() {
        return this.originalText == null ? "" : this.originalText;
    }

    private void updateOpenSuffixSpan() {
        if (TextUtils.isEmpty((CharSequence)this.mOpenSuffixStr)) {
            this.mOpenSuffixSpan = null;
            return;
        }
        this.mOpenSuffixSpan = new SpannableString((CharSequence)this.mOpenSuffixStr);
        this.mOpenSuffixSpan.setSpan((Object)new StyleSpan(1), 0, this.mOpenSuffixStr.length(), 33);
        this.mOpenSuffixSpan.setSpan((Object)new ClickableSpan(){

            public void onClick(@NonNull View widget) {
                ExpandAbleTextView.this.switchOpenClose();
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                ds.setColor(ExpandAbleTextView.this.mOpenSuffixColor);
                ds.setUnderlineText(false);
            }
        }, 0, this.mOpenSuffixStr.length(), 34);
    }

    private void updateCloseSuffixSpan() {
        if (TextUtils.isEmpty((CharSequence)this.mCloseSuffixStr)) {
            this.mCloseSuffixSpan = null;
            return;
        }
        this.mCloseSuffixSpan = new SpannableString((CharSequence)this.mCloseSuffixStr);
        this.mCloseSuffixSpan.setSpan((Object)new StyleSpan(1), 0, this.mCloseSuffixStr.length(), 33);
        if (this.mCloseInNewLine) {
            AlignmentSpan.Standard alignmentSpan = new AlignmentSpan.Standard(Layout.Alignment.ALIGN_OPPOSITE);
            this.mCloseSuffixSpan.setSpan((Object)alignmentSpan, 0, 1, 33);
        }
        this.mCloseSuffixSpan.setSpan((Object)new ClickableSpan(){

            public void onClick(@NonNull View widget) {
                ExpandAbleTextView.this.switchOpenClose();
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                ds.setColor(ExpandAbleTextView.this.mCloseSuffixColor);
                ds.setUnderlineText(false);
            }
        }, 1, this.mCloseSuffixStr.length(), 33);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setOpenAndCloseCallback(OpenAndCloseCallback callback) {
        this.mOpenCloseCallback = callback;
    }

    public void setCharSequenceToSpannableHandler(CharSequenceToSpannableHandler handler) {
        this.mCharSequenceToSpannableHandler = handler;
    }

    private static class ExpandCollapseAnimation
    extends Animation {
        private final View mTargetView;
        private final int mStartHeight;
        private final int mEndHeight;

        ExpandCollapseAnimation(View target, int startHeight, int endHeight) {
            this.mTargetView = target;
            this.mStartHeight = startHeight;
            this.mEndHeight = endHeight;
            this.setDuration(400L);
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            this.mTargetView.setScrollY(0);
            this.mTargetView.getLayoutParams().height = (int)((float)(this.mEndHeight - this.mStartHeight) * interpolatedTime + (float)this.mStartHeight);
            this.mTargetView.requestLayout();
        }
    }

    public static interface CharSequenceToSpannableHandler {
        @NonNull
        public SpannableStringBuilder charSequenceToSpannable(CharSequence var1);
    }

    public static interface OpenAndCloseCallback {
        public void onOpen();

        public void onClose();
    }
}

