/*
 * Decompiled with CFR 0.152.
 */
package com.lyy.keepassa.widget.ProgressBar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.example.uiwidget.R;

public class HorizontalProgressBarWithNumber
extends ProgressBar {
    private static final int DEFAULT_TEXT_SIZE = 10;
    private static final int DEFAULT_TEXT_COLOR = -261935;
    private static final int DEFAULT_COLOR_UNREACHED_COLOR = -2894118;
    private static final int DEFAULT_HEIGHT_REACHED_PROGRESS_BAR = 2;
    private static final int DEFAULT_HEIGHT_UNREACHED_PROGRESS_BAR = 2;
    private static final int DEFAULT_SIZE_TEXT_OFFSET = 10;
    protected Paint mPaint = new Paint();
    protected int mTextColor = -261935;
    protected int mTextSize = this.sp2px(10);
    protected int mTextOffset = this.dp2px(10);
    protected int mReachedProgressBarHeight = this.dp2px(2);
    protected int mReachedBarColor = -261935;
    protected int mUnReachedBarColor = -2894118;
    protected int mUnReachedProgressBarHeight = this.dp2px(2);
    protected int mRealWidth;
    protected boolean mIfDrawText = true;
    protected boolean showPercent = true;
    protected static final int VISIBLE = 0;

    public HorizontalProgressBarWithNumber(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalProgressBarWithNumber(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.obtainStyledAttributes(attrs);
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setColor(this.mTextColor);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.mRealWidth = this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft();
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            float textHeight = this.mPaint.descent() - this.mPaint.ascent();
            result = (int)((float)(this.getPaddingTop() + this.getPaddingBottom()) + Math.max((float)Math.max(this.mReachedProgressBarHeight, this.mUnReachedProgressBarHeight), Math.abs(textHeight)));
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private void obtainStyledAttributes(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalProgressBarWithNumber);
        this.mTextColor = attributes.getColor(R.styleable.HorizontalProgressBarWithNumber_progress_text_color, -261935);
        this.mTextSize = (int)attributes.getDimension(R.styleable.HorizontalProgressBarWithNumber_progress_text_size, (float)this.mTextSize);
        this.mReachedBarColor = attributes.getColor(R.styleable.HorizontalProgressBarWithNumber_progress_reached_color, this.mTextColor);
        this.mUnReachedBarColor = attributes.getColor(R.styleable.HorizontalProgressBarWithNumber_progress_unreached_color, -2894118);
        this.mReachedProgressBarHeight = (int)attributes.getDimension(R.styleable.HorizontalProgressBarWithNumber_progress_reached_bar_height, (float)this.mReachedProgressBarHeight);
        this.mUnReachedProgressBarHeight = (int)attributes.getDimension(R.styleable.HorizontalProgressBarWithNumber_progress_unreached_bar_height, (float)this.mUnReachedProgressBarHeight);
        this.mTextOffset = (int)attributes.getDimension(R.styleable.HorizontalProgressBarWithNumber_progress_text_offset, (float)this.mTextOffset);
        this.showPercent = attributes.getBoolean(R.styleable.HorizontalProgressBarWithNumber_progress_show_percent, true);
        int textVisible = attributes.getInt(R.styleable.HorizontalProgressBarWithNumber_progress_text_visibility, 0);
        if (textVisible != 0) {
            this.mIfDrawText = false;
        }
        attributes.recycle();
    }

    public void showPercent(boolean show) {
        this.showPercent = show;
    }

    protected synchronized void onDraw(Canvas canvas) {
        float endX;
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() >> 1));
        boolean noNeedBg = false;
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        float progressPosX = (int)((float)this.mRealWidth * radio);
        String text = this.getProgress() + (this.showPercent ? "%" : "");
        float textWidth = this.mPaint.measureText(text);
        float textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        if (progressPosX + textWidth > (float)this.mRealWidth) {
            progressPosX = (float)this.mRealWidth - textWidth;
            noNeedBg = true;
        }
        if ((endX = progressPosX - (float)(this.mTextOffset >> 1)) > 0.0f) {
            this.mPaint.setColor(this.mReachedBarColor);
            this.mPaint.setStrokeWidth((float)this.mReachedProgressBarHeight);
            canvas.drawLine(0.0f, 0.0f, endX, 0.0f, this.mPaint);
        }
        if (this.mIfDrawText) {
            this.mPaint.setColor(this.mTextColor);
            canvas.drawText(text, progressPosX, -textHeight, this.mPaint);
        }
        if (!noNeedBg) {
            float start = progressPosX + (float)(this.mTextOffset >> 1) + textWidth;
            this.mPaint.setColor(this.mUnReachedBarColor);
            this.mPaint.setStrokeWidth((float)this.mUnReachedProgressBarHeight);
            canvas.drawLine(start, 0.0f, (float)this.mRealWidth, 0.0f, this.mPaint);
        }
        canvas.restore();
    }

    protected int dp2px(int dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    protected int sp2px(int spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

